/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.ext.web.handler.impl.AuthorizationAuthHandler;
import java.util.List;

public class JWTAuthHandlerImpl
extends AuthorizationAuthHandler
implements JWTAuthHandler {
    private final String skip;
    private final JsonObject options;

    public JWTAuthHandlerImpl(JWTAuth authProvider) {
        super((AuthProvider)authProvider, AuthorizationAuthHandler.Type.BEARER);
        this.skip = null;
        this.options = new JsonObject();
    }

    @Deprecated
    public JWTAuthHandlerImpl(JWTAuth authProvider, String skip) {
        super((AuthProvider)authProvider, AuthorizationAuthHandler.Type.BEARER);
        this.skip = skip;
        this.options = new JsonObject();
    }

    @Override
    public JWTAuthHandler setAudience(List<String> audience) {
        this.options.put("audience", new JsonArray(audience));
        return this;
    }

    @Override
    public JWTAuthHandler setIssuer(String issuer) {
        this.options.put("issuer", issuer);
        return this;
    }

    @Override
    public JWTAuthHandler setIgnoreExpiration(boolean ignoreExpiration) {
        this.options.put("ignoreExpiration", Boolean.valueOf(ignoreExpiration));
        return this;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        if (this.skip != null && context.normalisedPath().startsWith(this.skip)) {
            context.next();
            return;
        }
        this.parseAuthorization(context, false, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            handler.handle((Object)Future.succeededFuture((Object)new JsonObject().put("jwt", (String)parseAuthorization.result()).put("options", this.options)));
        }));
    }

    @Override
    protected String authenticateHeader(RoutingContext context) {
        return "Bearer";
    }
}

