/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.impl.AuthorizationAuthHandler;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import java.net.MalformedURLException;
import java.net.URL;

public class OAuth2AuthHandlerImpl
extends AuthorizationAuthHandler
implements OAuth2AuthHandler {
    private final String host;
    private final String callbackPath;
    private final boolean supportJWT;
    private Route callback;
    private JsonObject extraParams = new JsonObject();

    public OAuth2AuthHandlerImpl(OAuth2Auth authProvider, String callbackURL) {
        super((AuthProvider)authProvider, AuthorizationAuthHandler.Type.BEARER);
        this.supportJWT = authProvider.hasJWTToken();
        try {
            URL url = new URL(callbackURL);
            this.host = url.getProtocol() + "://" + url.getHost() + (url.getPort() == -1 ? "" : ":" + url.getPort());
            this.callbackPath = url.getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        if (this.supportJWT) {
            this.parseAuthorization(context, true, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
                if (parseAuthorization.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                    return;
                }
                String token = (String)parseAuthorization.result();
                if (token != null) {
                    ((OAuth2Auth)this.authProvider).decodeToken(token, decodeToken -> {
                        if (decodeToken.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)new HttpStatusException(401, decodeToken.cause().getMessage())));
                            return;
                        }
                        context.setUser((User)decodeToken.result());
                        handler.handle((Object)Future.succeededFuture());
                    });
                }
            }));
        }
        handler.handle((Object)Future.failedFuture((Throwable)new HttpStatusException(302, this.authURI(this.host, context.request().uri()))));
    }

    private String authURI(String host, String redirectURL) {
        if (this.callback == null) {
            throw new NullPointerException("callback is null");
        }
        if (this.authorities.size() > 0) {
            JsonArray scopes = new JsonArray();
            for (String authority : this.authorities) {
                scopes.add(authority);
            }
            return ((OAuth2Auth)this.authProvider).authorizeURL(new JsonObject().put("redirect_uri", host + this.callback.getPath()).put("scopes", scopes).put("state", redirectURL));
        }
        return ((OAuth2Auth)this.authProvider).authorizeURL(new JsonObject().put("redirect_uri", host + this.callback.getPath()).put("state", redirectURL));
    }

    @Override
    public OAuth2AuthHandler extraParams(JsonObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    @Override
    public OAuth2AuthHandler setupCallback(Route route) {
        this.callback = route;
        if (!"".equals(this.callbackPath)) {
            this.callback.path(this.callbackPath);
        }
        this.callback.method(HttpMethod.GET);
        route.handler((Handler<RoutingContext>)((Handler)ctx -> {
            String code = ctx.request().getParam("code");
            if (code == null) {
                ctx.fail(400);
                return;
            }
            String state = ctx.request().getParam("state");
            ((OAuth2Auth)this.authProvider).getToken(new JsonObject().put("code", code).put("redirect_uri", this.host + this.callback.getPath()).mergeIn(this.extraParams), res -> {
                if (res.failed()) {
                    ctx.fail(res.cause());
                } else {
                    ctx.setUser((User)res.result());
                    Session session = ctx.session();
                    if (session != null) {
                        session.regenerateId();
                        ctx.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache, no-store, must-revalidate").putHeader("Pragma", "no-cache").putHeader(HttpHeaders.EXPIRES, (CharSequence)"0").putHeader(HttpHeaders.LOCATION, (CharSequence)state).setStatusCode(302).end("Redirecting to " + state + ".");
                    } else {
                        ctx.reroute(state);
                    }
                }
            });
        }));
        return this;
    }
}

