/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.LoggerFormat;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.impl.Utils;
import java.text.DateFormat;
import java.util.Date;

public class LoggerHandlerImpl
implements LoggerHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DateFormat dateTimeFormat = Utils.createRFC1123DateTimeFormatter();
    private final boolean immediate;
    private final LoggerFormat format;

    public LoggerHandlerImpl(boolean immediate, LoggerFormat format) {
        this.immediate = immediate;
        this.format = format;
    }

    public LoggerHandlerImpl(LoggerFormat format) {
        this(false, format);
    }

    private String getClientAddress(SocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.host();
    }

    private void log(RoutingContext context, long timestamp, String remoteClient, HttpVersion version, HttpMethod method, String uri) {
        HttpServerRequest request = context.request();
        long contentLength = 0L;
        if (this.immediate) {
            String obj = request.headers().get("content-length");
            if (obj != null) {
                try {
                    contentLength = Long.parseLong(obj.toString());
                }
                catch (NumberFormatException e) {
                    contentLength = 0L;
                }
            }
        } else {
            contentLength = request.response().bytesWritten();
        }
        String versionFormatted = "-";
        switch (version) {
            case HTTP_1_0: {
                versionFormatted = "HTTP/1.0";
                break;
            }
            case HTTP_1_1: {
                versionFormatted = "HTTP/1.1";
                break;
            }
            case HTTP_2: {
                versionFormatted = "HTTP/2.0";
            }
        }
        int status = request.response().getStatusCode();
        String message = null;
        switch (this.format) {
            case DEFAULT: {
                String referrer = request.headers().get("referrer");
                String userAgent = request.headers().get("user-agent");
                referrer = referrer == null ? "-" : referrer;
                userAgent = userAgent == null ? "-" : userAgent;
                message = String.format("%s - - [%s] \"%s %s %s\" %d %d \"%s\" \"%s\"", remoteClient, this.dateTimeFormat.format(new Date(timestamp)), method, uri, versionFormatted, status, contentLength, referrer, userAgent);
                break;
            }
            case SHORT: {
                message = String.format("%s - %s %s %s %d %d - %d ms", remoteClient, method, uri, versionFormatted, status, contentLength, System.currentTimeMillis() - timestamp);
                break;
            }
            case TINY: {
                message = String.format("%s %s %d %d - %d ms", method, uri, status, contentLength, System.currentTimeMillis() - timestamp);
            }
        }
        this.doLog(status, message);
    }

    protected void doLog(int status, String message) {
        if (status >= 500) {
            this.logger.error((Object)message);
        } else if (status >= 400) {
            this.logger.warn((Object)message);
        } else {
            this.logger.info((Object)message);
        }
    }

    public void handle(RoutingContext context) {
        long timestamp = System.currentTimeMillis();
        String remoteClient = this.getClientAddress(context.request().remoteAddress());
        HttpMethod method = context.request().method();
        String uri = context.request().uri();
        HttpVersion version = context.request().version();
        if (this.immediate) {
            this.log(context, timestamp, remoteClient, version, method, uri);
        } else {
            context.addBodyEndHandler((Handler<Void>)((Handler)v -> this.log(context, timestamp, remoteClient, version, method, uri)));
        }
        context.next();
    }
}

