/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.impl.SessionImpl;
import java.util.HashSet;

public class LocalSessionStoreImpl
implements LocalSessionStore,
Handler<Long> {
    protected final Vertx vertx;
    protected final LocalMap<String, Session> localMap;
    private final long reaperInterval;
    private long timerID = -1L;
    private boolean closed;

    public LocalSessionStoreImpl(Vertx vertx, String sessionMapName, long reaperInterval) {
        this.vertx = vertx;
        this.reaperInterval = reaperInterval;
        this.localMap = vertx.sharedData().getLocalMap(sessionMapName);
        this.setTimer();
    }

    @Override
    public Session createSession(long timeout) {
        return new SessionImpl(timeout);
    }

    @Override
    public void get(String id, Handler<AsyncResult<Session>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)this.localMap.get((Object)id)));
    }

    @Override
    public void delete(String id, Handler<AsyncResult<Boolean>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)(this.localMap.remove((Object)id) != null ? 1 : 0)));
    }

    @Override
    public void put(Session session, Handler<AsyncResult<Boolean>> resultHandler) {
        this.localMap.put((Object)session.id(), (Object)session);
        resultHandler.handle((Object)Future.succeededFuture((Object)true));
    }

    @Override
    public void clear(Handler<AsyncResult<Boolean>> resultHandler) {
        this.localMap.clear();
        resultHandler.handle((Object)Future.succeededFuture((Object)true));
    }

    @Override
    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)this.localMap.size()));
    }

    @Override
    public synchronized void close() {
        this.localMap.close();
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        this.closed = true;
    }

    public synchronized void handle(Long tid) {
        long now = System.currentTimeMillis();
        HashSet<String> toRemove = new HashSet<String>();
        for (Session session : this.localMap.values()) {
            if (now - session.lastAccessed() <= session.timeout()) continue;
            toRemove.add(session.id());
        }
        for (String id : toRemove) {
            this.localMap.remove((Object)id);
        }
        if (!this.closed) {
            this.setTimer();
        }
    }

    private void setTimer() {
        if (this.reaperInterval != 0L) {
            this.timerID = this.vertx.setTimer(this.reaperInterval, (Handler)this);
        }
    }
}

