/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RoutingContextDecorator;
import java.util.Objects;

public class BlockingHandlerDecorator
implements Handler<RoutingContext> {
    private Handler<RoutingContext> decoratedHandler;

    public BlockingHandlerDecorator(Handler<RoutingContext> decoratedHandler) {
        Objects.requireNonNull(decoratedHandler);
        this.decoratedHandler = decoratedHandler;
    }

    public void handle(RoutingContext context) {
        Route currentRoute = context.currentRoute();
        context.vertx().executeBlocking(fut -> {
            this.decoratedHandler.handle((Object)new RoutingContextDecorator(currentRoute, context));
            fut.complete();
        }, res -> {
            if (res.failed()) {
                context.fail(res.cause());
            }
        });
    }
}

