/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.validation.RequestPredicateResult;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;

@VertxGen
public interface RequestPredicate
extends Function<RoutingContext, RequestPredicateResult> {
    public static final RequestPredicate BODY_REQUIRED = rc -> {
        if (!rc.request().headers().contains(HttpHeaders.CONTENT_TYPE)) {
            return RequestPredicateResult.failed("Body required");
        }
        return RequestPredicateResult.success();
    };

    public static RequestPredicate multipartFileUploadExists(String propertyName, String contentTypePattern) {
        Pattern contentType = Pattern.compile(contentTypePattern);
        return rc -> {
            if (rc.request().headers().contains(HttpHeaders.CONTENT_TYPE) && rc.request().getHeader(HttpHeaders.CONTENT_TYPE).contains("multipart/form-data")) {
                Set files = rc.fileUploads();
                for (FileUpload f : files) {
                    if (!f.name().equals(propertyName) || !contentType.matcher(f.contentType()).matches()) continue;
                    return RequestPredicateResult.success();
                }
                return RequestPredicateResult.failed(String.format("File with content type %s and name %s is missing", contentType.toString(), propertyName));
            }
            return RequestPredicateResult.success();
        };
    }
}

