/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.LanguageHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.templ.ThymeleafTemplateEngine;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public class ThymeleafTemplateEngineImpl
implements ThymeleafTemplateEngine {
    private final TemplateEngine templateEngine = new TemplateEngine();
    private ResourceTemplateResolver templateResolver;

    public ThymeleafTemplateEngineImpl() {
        ResourceTemplateResolver templateResolver = new ResourceTemplateResolver();
        templateResolver.setTemplateMode(ThymeleafTemplateEngine.DEFAULT_TEMPLATE_MODE);
        this.templateResolver = templateResolver;
        this.templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
    }

    @Override
    public ThymeleafTemplateEngine setMode(TemplateMode mode) {
        this.templateResolver.setTemplateMode(mode);
        return this;
    }

    @Override
    public TemplateEngine getThymeleafTemplateEngine() {
        return this.templateEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RoutingContext context, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
        final Buffer buffer = Buffer.buffer();
        try {
            HashMap<String, RoutingContext> data = new HashMap<String, RoutingContext>();
            data.put("context", context);
            data.putAll(context.data());
            ThymeleafTemplateEngineImpl thymeleafTemplateEngineImpl = this;
            synchronized (thymeleafTemplateEngineImpl) {
                this.templateResolver.setVertx(context.vertx());
                List acceptableLocales = context.acceptableLanguages();
                LanguageHeader locale = null;
                if (acceptableLocales.size() > 0) {
                    locale = (LanguageHeader)acceptableLocales.get(0);
                }
                this.templateEngine.process(templateFileName, (IContext)new WebIContext(data, locale), new Writer(){

                    @Override
                    public void write(char[] cbuf, int off, int len) throws IOException {
                        buffer.appendString(new String(cbuf, off, len));
                    }

                    @Override
                    public void flush() throws IOException {
                    }

                    @Override
                    public void close() throws IOException {
                    }
                });
            }
            handler.handle((Object)Future.succeededFuture((Object)buffer));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }

    private static class ResourceTemplateResolver
    extends StringTemplateResolver {
        private Vertx vertx;

        public ResourceTemplateResolver() {
            this.setName("vertx-web/Thymeleaf3");
        }

        void setVertx(Vertx vertx) {
            this.vertx = vertx;
        }

        protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
            String str = Utils.readFileToString((Vertx)this.vertx, (String)template);
            return new StringTemplateResource(str);
        }
    }

    private static class WebIContext
    implements IContext {
        private final Map<String, Object> data;
        private final Locale locale;

        private WebIContext(Map<String, Object> data, LanguageHeader locale) {
            Locale locale2;
            this.data = data;
            if (locale == null) {
                locale2 = Locale.getDefault();
            } else {
                String variant = locale.subtag(2);
                String string = variant == null ? "" : variant;
                locale2 = new Locale(locale.tag(), locale.subtag(), string);
            }
            this.locale = locale2;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean containsVariable(String name) {
            return this.data.containsKey(name);
        }

        public Set<String> getVariableNames() {
            return this.data.keySet();
        }

        public Object getVariable(String name) {
            return this.data.get(name);
        }
    }
}

