/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import com.fizzed.rocker.BindableRockerModel;
import com.fizzed.rocker.Rocker;
import com.fizzed.rocker.RockerOutputFactory;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.templ.RockerTemplateEngine;
import io.vertx.ext.web.templ.impl.CachingTemplateEngine;
import io.vertx.ext.web.templ.impl.VertxBufferOutput;

public class RockerTemplateEngineImpl
extends CachingTemplateEngine<Void>
implements RockerTemplateEngine {
    public RockerTemplateEngineImpl() {
        super("rocker.html", 10000);
    }

    @Override
    public RockerTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public RockerTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    public void render(RoutingContext context, String templateDirectory, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
        try {
            templateFileName = templateDirectory + templateFileName;
            String templatePath = this.adjustLocation(templateFileName);
            BindableRockerModel model = Rocker.template((String)templatePath);
            model.bind("context", (Object)context);
            model.bind(context.data());
            VertxBufferOutput output = (VertxBufferOutput)model.render((RockerOutputFactory)VertxBufferOutput.FACTORY);
            handler.handle((Object)Future.succeededFuture((Object)output.getBuffer()));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }
}

