/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.pebble.impl;

import com.mitchellbosecke.pebble.attributes.AttributeResolver;
import com.mitchellbosecke.pebble.attributes.ResolvedAttribute;
import com.mitchellbosecke.pebble.error.AttributeNotFoundException;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.template.EvaluationContextImpl;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

class PebbleVertxAttributeResolver
implements AttributeResolver {
    PebbleVertxAttributeResolver() {
    }

    public ResolvedAttribute resolve(Object instance, Object attributeNameValue, Object[] argumentValues, ArgumentsNode args, EvaluationContextImpl context, String filename, int lineNumber) {
        if (instance instanceof JsonObject) {
            ResolvedAttribute resolvedAttribute = new ResolvedAttribute(null);
            if (attributeNameValue instanceof String) {
                JsonObject jsonObject = (JsonObject)instance;
                resolvedAttribute = new ResolvedAttribute(jsonObject.getValue((String)attributeNameValue));
            }
            if (context.isStrictVariables() && resolvedAttribute.evaluatedValue == null) {
                throw new AttributeNotFoundException(null, String.format("Attribute [%s] of [%s] does not exist or can not be accessed and strict variables is set to true.", attributeNameValue.toString(), instance.getClass().getName()), attributeNameValue.toString(), lineNumber, filename);
            }
            return resolvedAttribute;
        }
        if (instance instanceof JsonArray) {
            int index;
            JsonArray jsonArray = (JsonArray)instance;
            String attributeName = String.valueOf(attributeNameValue);
            try {
                index = Integer.parseInt(attributeName);
            }
            catch (NumberFormatException e) {
                return null;
            }
            int length = jsonArray.size();
            if (index < 0 || index >= length) {
                if (context.isStrictVariables()) {
                    throw new AttributeNotFoundException(null, "Index out of bounds while accessing JsonArray with strict variables on.", attributeName, lineNumber, filename);
                }
                return new ResolvedAttribute(null);
            }
            return new ResolvedAttribute(jsonArray.getValue(index));
        }
        return null;
    }
}

