/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.ParsedHeaderValue;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.templ.PebbleTemplateEngine;
import io.vertx.ext.web.templ.impl.CachingTemplateEngine;
import io.vertx.ext.web.templ.impl.PebbleVertxLoader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;

public class PebbleTemplateEngineImpl
extends CachingTemplateEngine<PebbleTemplate>
implements PebbleTemplateEngine {
    private final PebbleEngine pebbleEngine;

    public PebbleTemplateEngineImpl(Vertx vertx) {
        this(new PebbleEngine.Builder().loader((Loader)new PebbleVertxLoader(vertx)).cacheActive(false).build());
    }

    public PebbleTemplateEngineImpl(PebbleEngine engine) {
        super("peb", 10000);
        this.pebbleEngine = engine;
    }

    @Override
    public PebbleTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public PebbleTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    public void render(RoutingContext context, String templateDirectory, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
        try {
            PebbleTemplate template;
            templateFileName = templateDirectory + templateFileName;
            PebbleTemplate pebbleTemplate = template = this.isCachingEnabled() ? (PebbleTemplate)this.cache.get((Object)templateFileName) : null;
            if (template == null) {
                String loc = this.adjustLocation(templateFileName);
                template = this.pebbleEngine.getTemplate(loc);
                if (this.isCachingEnabled()) {
                    this.cache.put((Object)templateFileName, (Object)template);
                }
            }
            Locale locale = context.acceptableLanguages().stream().findFirst().map(ParsedHeaderValue::value).map(Locale::forLanguageTag).orElseGet(Locale::getDefault);
            HashMap<String, RoutingContext> variables = new HashMap<String, RoutingContext>(1);
            variables.put("context", context);
            variables.putAll(context.data());
            StringWriter stringWriter = new StringWriter();
            template.evaluate((Writer)stringWriter, variables, locale);
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)stringWriter.toString())));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }
}

