/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.mvel.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.common.template.impl.TemplateHolder;
import io.vertx.ext.web.templ.mvel.MVELTemplateEngine;
import java.nio.charset.Charset;
import java.util.Map;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ImmutableDefaultFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.mvel2.util.StringAppender;

public class MVELTemplateEngineImpl
extends CachingTemplateEngine<CompiledTemplate>
implements MVELTemplateEngine {
    private final Vertx vertx;

    public MVELTemplateEngineImpl(Vertx vertx, String extension) {
        super(vertx, extension);
        this.vertx = vertx;
    }

    public void render(Map<String, Object> context, String templateFile, Handler<AsyncResult<Buffer>> handler) {
        try {
            String baseDir;
            String src = this.adjustLocation(templateFile);
            TemplateHolder template = this.getTemplate(src);
            if (template == null) {
                int idx = src.lastIndexOf(47);
                baseDir = "";
                if (idx != -1) {
                    baseDir = src.substring(0, idx);
                }
                if (!this.vertx.fileSystem().existsBlocking(src)) {
                    handler.handle((Object)Future.failedFuture((String)("Cannot find template " + src)));
                    return;
                }
                template = new TemplateHolder((Object)TemplateCompiler.compileTemplate((String)this.vertx.fileSystem().readFileBlocking(src).toString(Charset.defaultCharset())), baseDir);
                this.putTemplate(src, template);
            }
            CompiledTemplate mvel = (CompiledTemplate)template.template();
            baseDir = template.baseDir();
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)((String)new TemplateRuntime(mvel.getTemplate(), null, mvel.getRoot(), baseDir).execute(new StringAppender(), context, (VariableResolverFactory)new ImmutableDefaultFactory())))));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }
}

