/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.mvel.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.templ.mvel.MVELTemplateEngine;
import java.nio.charset.Charset;
import java.util.Map;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ImmutableDefaultFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.mvel2.util.StringAppender;

public class MVELTemplateEngineImpl
extends CachingTemplateEngine<CompiledTemplate>
implements MVELTemplateEngine {
    private final Vertx vertx;

    public MVELTemplateEngineImpl(Vertx vertx) {
        super("templ", 10000);
        this.vertx = vertx;
    }

    @Override
    public MVELTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public MVELTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    public void render(Map<String, Object> context, String templateFile, Handler<AsyncResult<Buffer>> handler) {
        try {
            CompiledTemplate template;
            int idx = templateFile.lastIndexOf(47);
            String prefix = "";
            if (idx != -1) {
                prefix = templateFile.substring(0, idx);
            }
            CompiledTemplate compiledTemplate = template = this.isCachingEnabled() ? (CompiledTemplate)this.cache.get((Object)templateFile) : null;
            if (template == null) {
                String loc = this.adjustLocation(templateFile);
                String templ = null;
                if (this.vertx.fileSystem().existsBlocking(loc)) {
                    templ = this.vertx.fileSystem().readFileBlocking(loc).toString(Charset.defaultCharset());
                }
                if (templ == null) {
                    handler.handle((Object)Future.failedFuture((String)("Cannot find template " + loc)));
                    return;
                }
                template = TemplateCompiler.compileTemplate(templ);
                if (this.isCachingEnabled()) {
                    this.cache.put((Object)templateFile, (Object)template);
                }
            }
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)((String)new TemplateRuntime(template.getTemplate(), null, template.getRoot(), prefix).execute(new StringAppender(), context, (VariableResolverFactory)new ImmutableDefaultFactory())))));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }
}

