/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.templ.MVELTemplateEngine;
import io.vertx.ext.web.templ.impl.CachingTemplateEngine;
import java.util.HashMap;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ImmutableDefaultFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.mvel2.util.StringAppender;

public class MVELTemplateEngineImpl
extends CachingTemplateEngine<CompiledTemplate>
implements MVELTemplateEngine {
    public MVELTemplateEngineImpl() {
        super("templ", 10000);
    }

    @Override
    public MVELTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public MVELTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    public void render(RoutingContext context, String templateDirectory, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
        try {
            CompiledTemplate template;
            templateFileName = templateDirectory + templateFileName;
            CompiledTemplate compiledTemplate = template = this.isCachingEnabled() ? (CompiledTemplate)this.cache.get((Object)templateFileName) : null;
            if (template == null) {
                String loc = this.adjustLocation(templateFileName);
                String templateText = Utils.readFileToString((Vertx)context.vertx(), (String)loc);
                if (templateText == null) {
                    throw new IllegalArgumentException("Cannot find template " + loc);
                }
                template = TemplateCompiler.compileTemplate((String)templateText);
                if (this.isCachingEnabled()) {
                    this.cache.put((Object)templateFileName, (Object)template);
                }
            }
            HashMap<String, RoutingContext> variables = new HashMap<String, RoutingContext>(1);
            variables.put("context", context);
            VertxInternal vertxInternal = (VertxInternal)context.vertx();
            String directoryName = vertxInternal.resolveFile(templateFileName).getParent();
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)((String)new TemplateRuntime(template.getTemplate(), null, template.getRoot(), directoryName).execute(new StringAppender(), variables, (VariableResolverFactory)new ImmutableDefaultFactory())))));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }
}

