/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.jte.impl;

import gg.jte.CodeResolver;
import io.vertx.core.Vertx;
import io.vertx.ext.web.common.WebEnvironment;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VertxDirectoryCodeResolver
implements CodeResolver {
    private final Vertx vertx;
    private final Path templateRootDirectory;
    private final ConcurrentMap<String, Long> modificationTimes;

    public VertxDirectoryCodeResolver(Vertx vertx, String templateRootDirectory) {
        this.vertx = vertx;
        this.templateRootDirectory = Paths.get(templateRootDirectory, new String[0]);
        this.modificationTimes = WebEnvironment.development() ? new ConcurrentHashMap<String, Long>() : null;
    }

    public String resolve(String name) {
        name = this.templateRootDirectory.resolve(name).toString();
        String templateCode = this.vertx.fileSystem().readFileBlocking(name).toString();
        if (templateCode == null) {
            return null;
        }
        if (this.modificationTimes != null) {
            this.modificationTimes.put(name, this.getLastModified(name));
        }
        return templateCode;
    }

    public boolean hasChanged(String name) {
        if (this.modificationTimes == null) {
            return false;
        }
        Long lastResolveTime = (Long)this.modificationTimes.get(name = this.templateRootDirectory.resolve(name).toString());
        if (lastResolveTime == null) {
            return true;
        }
        long lastModified = this.getLastModified(name);
        return lastModified != lastResolveTime;
    }

    private long getLastModified(String name) {
        return this.vertx.fileSystem().propsBlocking(name).lastModifiedTime();
    }

    public void clear() {
        if (this.modificationTimes != null) {
            this.modificationTimes.clear();
        }
    }
}

