/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.AbstractSession;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SharedDataSessionImpl;
import io.vertx.ext.web.sstore.redis.RedisSessionStore;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.Objects;

public class RedisSessionStoreImpl
implements RedisSessionStore {
    private Redis redis;
    private VertxContextPRNG random;
    private long retryTimeout;

    public SessionStore init(Vertx vertx, JsonObject options) {
        Objects.requireNonNull(options, "options are required");
        long timeout = options.getLong("retryTimeout", Long.valueOf(2000L));
        Redis redis = Redis.createClient((Vertx)vertx, (RedisOptions)new RedisOptions(options));
        return this.init(vertx, timeout, redis);
    }

    public SessionStore init(Vertx vertx, long retryTimeout, Redis redis) {
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.retryTimeout = retryTimeout;
        this.redis = Objects.requireNonNull(redis, "redis is required");
        return this;
    }

    public long retryTimeout() {
        return this.retryTimeout;
    }

    public Session createSession(long timeout) {
        return this.createSession(timeout, 16);
    }

    public Session createSession(long timeout, int length) {
        return new SharedDataSessionImpl(this.random, timeout, length);
    }

    public void get(String id, Handler<AsyncResult<Session>> resultHandler) {
        this.redis.send(Request.cmd((Command)Command.GET).arg(id), resGet -> {
            if (resGet.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)resGet.cause()));
                return;
            }
            Response response = (Response)resGet.result();
            if (response != null) {
                SharedDataSessionImpl session = new SharedDataSessionImpl(this.random);
                session.readFromBuffer(0, response.toBuffer());
                this.redis.send(Request.cmd((Command)Command.PEXPIRE).arg(id).arg(session.timeout()), resExpire -> {
                    if (resExpire.failed()) {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)resExpire.cause()));
                    } else {
                        resultHandler.handle((Object)Future.succeededFuture((Object)session));
                    }
                });
            } else {
                resultHandler.handle((Object)Future.succeededFuture());
            }
        });
    }

    public void delete(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.redis.send(Request.cmd((Command)Command.DEL).arg(id), res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture());
            }
        });
    }

    public void put(Session session, Handler<AsyncResult<Void>> resultHandler) {
        this.redis.send(Request.cmd((Command)Command.GET).arg(session.id()), res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            AbstractSession newSession = (AbstractSession)session;
            Response response = (Response)res.result();
            if (response != null) {
                SharedDataSessionImpl oldSession = new SharedDataSessionImpl(this.random);
                oldSession.readFromBuffer(0, response.toBuffer());
                if (oldSession.version() != newSession.version()) {
                    resultHandler.handle((Object)Future.failedFuture((String)"Session version mismatch"));
                    return;
                }
            }
            newSession.incrementVersion();
            this.writeSession((Session)newSession, resultHandler);
        });
    }

    private void writeSession(Session session, Handler<AsyncResult<Void>> resultHandler) {
        Buffer buffer = Buffer.buffer();
        SharedDataSessionImpl sessionImpl = (SharedDataSessionImpl)session;
        sessionImpl.writeToBuffer(buffer);
        Request rq = Request.cmd((Command)Command.SET).arg(session.id()).arg(buffer).arg("PX").arg(session.timeout());
        this.redis.send(rq, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture());
            }
        });
    }

    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.redis.send(Request.cmd((Command)Command.FLUSHDB), res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture());
            }
        });
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.redis.send(Request.cmd((Command)Command.DBSIZE), res -> {
            if (res.succeeded()) {
                long lngCount = ((Response)res.result()).toLong();
                int count = lngCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lngCount;
                resultHandler.handle((Object)Future.succeededFuture((Object)count));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    public void close() {
        this.redis.close();
    }
}

