/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.cookie.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.sstore.AbstractSession;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CookieSession
extends AbstractSession {
    private static final Base64.Encoder BASE64_URL_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder BASE64_URL_DECODER = Base64.getUrlDecoder();
    private static final String AES_ALGORITHM_GCM = "AES/GCM/NoPadding";
    private static final int IV_LENGTH = 12;
    private static final int TAG_LENGTH = 16;
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final SecretKeySpec aesKey;
    private final VertxContextPRNG prng;
    private int oldVersion = 0;
    private int oldCrc = 0;

    public static String base64UrlEncode(byte[] bytes) {
        return BASE64_URL_ENCODER.encodeToString(bytes);
    }

    public static byte[] base64UrlDecode(String base64) {
        return BASE64_URL_DECODER.decode(base64);
    }

    public CookieSession(SecretKeySpec aesKey, VertxContextPRNG prng, long timeout, int length) {
        super(prng, timeout, length);
        this.prng = prng;
        this.aesKey = aesKey;
    }

    public CookieSession(SecretKeySpec aesKey, VertxContextPRNG prng) {
        super(prng);
        this.prng = prng;
        this.aesKey = aesKey;
    }

    public String value() {
        Buffer buff = Buffer.buffer();
        byte[] bytes = this.id().getBytes(UTF8);
        buff.appendInt(bytes.length).appendBytes(bytes);
        buff.appendLong(this.timeout());
        buff.appendLong(this.lastAccessed());
        buff.appendInt(this.version());
        this.writeDataToBuffer(buff);
        try {
            return this.encrypt(buff);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRegenerated() {
        if (!super.isRegenerated()) {
            return this.oldCrc != this.checksum();
        }
        return true;
    }

    protected CookieSession setValue(String payload) {
        if (payload == null) {
            throw new NullPointerException();
        }
        try {
            Buffer buffer = this.decrypt(payload);
            int pos = 0;
            int len = buffer.getInt(0);
            byte[] bytes = buffer.getBytes(pos += 4, pos + len);
            this.setId(new String(bytes, UTF8));
            this.setTimeout(buffer.getLong(pos += len));
            this.setLastAccessed(buffer.getLong(pos += 8));
            this.setVersion(buffer.getInt(pos += 8));
            this.readDataFromBuffer(pos += 4, buffer);
            this.oldVersion = this.version();
            this.oldCrc = this.crc();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return null;
        }
        return this;
    }

    int oldVersion() {
        return this.oldVersion;
    }

    private String encrypt(Buffer data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] iv = new byte[12];
        this.prng.nextBytes(iv);
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM_GCM);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)this.aesKey, gcmSpec);
        byte[] encryptedBytes = cipher.doFinal(data.getBytes());
        byte[] combinedIvAndCipherText = new byte[iv.length + encryptedBytes.length];
        System.arraycopy(iv, 0, combinedIvAndCipherText, 0, iv.length);
        System.arraycopy(encryptedBytes, 0, combinedIvAndCipherText, iv.length, encryptedBytes.length);
        return CookieSession.base64UrlEncode(combinedIvAndCipherText);
    }

    private Buffer decrypt(String data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] decodedCipherText = CookieSession.base64UrlDecode(data);
        byte[] iv = new byte[12];
        System.arraycopy(decodedCipherText, 0, iv, 0, iv.length);
        byte[] encryptedText = new byte[decodedCipherText.length - 12];
        System.arraycopy(decodedCipherText, 12, encryptedText, 0, encryptedText.length);
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM_GCM);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)this.aesKey, gcmSpec);
        byte[] decryptedBytes = cipher.doFinal(encryptedText);
        return Buffer.buffer((byte[])decryptedBytes);
    }
}

