/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.cookie.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.cookie.CookieSessionStore;
import io.vertx.ext.web.sstore.cookie.impl.CookieSession;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CookieSessionStoreImpl
implements CookieSessionStore {
    private Cipher encrypt;
    private Cipher decrypt;
    private VertxContextPRNG random;
    private ContextInternal ctx;

    public CookieSessionStoreImpl() {
    }

    public CookieSessionStoreImpl(Vertx vertx, String secret, Buffer salt) {
        this.init(vertx, new JsonObject().put("secret", (Object)secret).put("salt", (Object)salt));
    }

    public SessionStore init(Vertx vertx, JsonObject options) {
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.ctx = (ContextInternal)vertx.getOrCreateContext();
        Objects.requireNonNull(options.getValue("secret"), "secret must be set");
        Objects.requireNonNull(options.getValue("salt"), "salt must be set");
        try {
            byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            if (options.containsKey("iv")) {
                byte[] tmp = options.getBinary("iv");
                for (int i = 0; i < tmp.length && i < iv.length; ++i) {
                    iv[i] = tmp[i];
                }
            } else {
                this.random.nextBytes(iv);
            }
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(options.getString("secret").toCharArray(), options.getBinary("salt"), 65536, 256);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
            this.encrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.encrypt.init(1, (Key)secretKey, ivspec);
            this.decrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.decrypt.init(2, (Key)secretKey, ivspec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public long retryTimeout() {
        return -1L;
    }

    public Session createSession(long timeout) {
        return new CookieSession(this.encrypt, this.decrypt, this.random, timeout, 16);
    }

    public Session createSession(long timeout, int length) {
        return new CookieSession(this.encrypt, this.decrypt, this.random, timeout, length);
    }

    public Future<@Nullable Session> get(String cookieValue) {
        try {
            CookieSession session = new CookieSession(this.encrypt, this.decrypt, this.random).setValue(cookieValue);
            if (session == null) {
                return this.ctx.succeededFuture();
            }
            long now = System.currentTimeMillis();
            if (now - session.lastAccessed() > session.timeout()) {
                return this.ctx.succeededFuture();
            }
            return this.ctx.succeededFuture((Object)session);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    public Future<Void> delete(String id) {
        return this.ctx.succeededFuture();
    }

    public Future<Void> put(Session session) {
        CookieSession cookieSession = (CookieSession)session;
        if (cookieSession.oldVersion() != -1 && cookieSession.oldVersion() != cookieSession.version()) {
            return Future.failedFuture((String)"Session version mismatch");
        }
        cookieSession.incrementVersion();
        return this.ctx.succeededFuture();
    }

    public Future<Void> clear() {
        return this.ctx.succeededFuture();
    }

    public Future<Integer> size() {
        return this.ctx.succeededFuture((Object)0);
    }

    public void close() {
    }
}

