/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions;
import java.util.LinkedHashMap;
import java.util.Map;

public class GraphiQLHandlerOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, GraphiQLHandlerOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "enabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setEnabled((Boolean)member.getValue());
                    break;
                }
                case "httpEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHttpEnabled((Boolean)member.getValue());
                    break;
                }
                case "graphQLUri": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setGraphQLUri((String)member.getValue());
                    break;
                }
                case "graphQLWSEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setGraphQLWSEnabled((Boolean)member.getValue());
                    break;
                }
                case "graphQLWSUri": {
                    break;
                }
                case "graphWSQLUri": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setGraphWSQLUri((String)member.getValue());
                    break;
                }
                case "headers": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setHeaders(map);
                    break;
                }
                case "wsConnectionParams": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setWsConnectionParams(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "query": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setQuery((String)member.getValue());
                    break;
                }
                case "variables": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setVariables(((JsonObject)member.getValue()).copy());
                }
            }
        }
    }

    static void toJson(GraphiQLHandlerOptions obj, JsonObject json) {
        GraphiQLHandlerOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(GraphiQLHandlerOptions obj, Map<String, Object> json) {
        json.put("enabled", obj.isEnabled());
        json.put("httpEnabled", obj.isHttpEnabled());
        if (obj.getGraphQLUri() != null) {
            json.put("graphQLUri", obj.getGraphQLUri());
        }
        json.put("graphQLWSEnabled", obj.isGraphQLWSEnabled());
        if (obj.getGraphQLWSUri() != null) {
            json.put("graphQLWSUri", obj.getGraphQLWSUri());
        }
        if (obj.getHeaders() != null) {
            JsonObject map = new JsonObject();
            obj.getHeaders().forEach((key, value) -> map.put(key, value));
            json.put("headers", map);
        }
        if (obj.getWsConnectionParams() != null) {
            json.put("wsConnectionParams", obj.getWsConnectionParams());
        }
        if (obj.getQuery() != null) {
            json.put("query", obj.getQuery());
        }
        if (obj.getVariables() != null) {
            json.put("variables", obj.getVariables());
        }
    }
}

