/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.impl.ws;

import graphql.GraphQL;
import io.vertx.core.Handler;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext;
import io.vertx.ext.web.handler.graphql.impl.ws.ConnectionHandler;
import io.vertx.ext.web.handler.graphql.ws.ConnectionInitEvent;
import io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler;
import io.vertx.ext.web.handler.graphql.ws.GraphQLWSOptions;
import io.vertx.ext.web.handler.graphql.ws.Message;

public class GraphQLWSHandlerImpl
implements GraphQLWSHandler {
    private final GraphQL graphQL;
    private final long connectionInitWaitTimeout;
    private final Handler<ConnectionInitEvent> connectionInitHandler;
    private final Handler<ExecutionInputBuilderWithContext<Message>> beforeExecuteHandler;
    private final Handler<Message> messageHandler;
    private final Handler<ServerWebSocket> endHandler;

    public GraphQLWSHandlerImpl(GraphQL graphQL, GraphQLWSOptions options, Handler<ConnectionInitEvent> connectionInitHandler, Handler<ExecutionInputBuilderWithContext<Message>> beforeExecuteHandler, Handler<Message> messageHandler, Handler<ServerWebSocket> endHandler) {
        this.graphQL = graphQL;
        this.connectionInitWaitTimeout = options == null ? 3000L : options.getConnectionInitWaitTimeout();
        this.connectionInitHandler = connectionInitHandler;
        this.beforeExecuteHandler = beforeExecuteHandler;
        this.messageHandler = messageHandler;
        this.endHandler = endHandler;
    }

    public void handle(RoutingContext rc) {
        if (rc.request().canUpgradeToWebSocket()) {
            rc.request().toWebSocket().onFailure(arg_0 -> ((RoutingContext)rc).fail(arg_0)).onSuccess(socket -> {
                ConnectionHandler handler = new ConnectionHandler(this.graphQL, this.connectionInitWaitTimeout, this.connectionInitHandler, this.beforeExecuteHandler, this.messageHandler, this.endHandler, rc, (ServerWebSocket)socket);
                handler.handleConnection();
            });
        } else {
            rc.next();
        }
    }
}

