/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.impl;

import graphql.ExecutionInput;
import graphql.GraphQL;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.graphql.GraphQLHandler;
import io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions;
import io.vertx.ext.web.handler.graphql.impl.GraphQLBatch;
import io.vertx.ext.web.handler.graphql.impl.GraphQLInput;
import io.vertx.ext.web.handler.graphql.impl.GraphQLQuery;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.dataloader.DataLoaderRegistry;

public class GraphQLHandlerImpl
implements GraphQLHandler {
    private static final Pattern IS_NUMBER = Pattern.compile("\\d+");
    private static final Function<RoutingContext, Object> DEFAULT_QUERY_CONTEXT_FACTORY = rc -> rc;
    private static final Function<RoutingContext, DataLoaderRegistry> DEFAULT_DATA_LOADER_REGISTRY_FACTORY = rc -> null;
    private static final Function<RoutingContext, Locale> DEFAULT_LOCALE_FACTORY = rc -> null;
    private final GraphQL graphQL;
    private final GraphQLHandlerOptions options;
    private Function<RoutingContext, Object> queryContextFactory = DEFAULT_QUERY_CONTEXT_FACTORY;
    private Function<RoutingContext, DataLoaderRegistry> dataLoaderRegistryFactory = DEFAULT_DATA_LOADER_REGISTRY_FACTORY;
    private Function<RoutingContext, Locale> localeFactory = DEFAULT_LOCALE_FACTORY;

    public GraphQLHandlerImpl(GraphQL graphQL, GraphQLHandlerOptions options) {
        Objects.requireNonNull(graphQL, "graphQL");
        Objects.requireNonNull(options, "options");
        this.graphQL = graphQL;
        this.options = options;
    }

    @Override
    public synchronized GraphQLHandler queryContext(Function<RoutingContext, Object> factory) {
        this.queryContextFactory = factory != null ? factory : DEFAULT_QUERY_CONTEXT_FACTORY;
        return this;
    }

    @Override
    public synchronized GraphQLHandler dataLoaderRegistry(Function<RoutingContext, DataLoaderRegistry> factory) {
        this.dataLoaderRegistryFactory = factory != null ? factory : DEFAULT_DATA_LOADER_REGISTRY_FACTORY;
        return this;
    }

    @Override
    public synchronized GraphQLHandler locale(Function<RoutingContext, Locale> factory) {
        this.localeFactory = factory != null ? factory : DEFAULT_LOCALE_FACTORY;
        return this;
    }

    public void handle(RoutingContext rc) {
        HttpMethod method = rc.request().method();
        if (method == HttpMethod.GET) {
            this.handleGet(rc);
        } else if (method == HttpMethod.POST) {
            Buffer body = rc.getBody();
            if (body == null) {
                rc.request().bodyHandler(buffer -> this.handlePost(rc, (Buffer)buffer));
            } else {
                this.handlePost(rc, body);
            }
        } else {
            rc.fail(405);
        }
    }

    private void handleGet(RoutingContext rc) {
        Map<String, Object> variables;
        String query = rc.queryParams().get("query");
        if (query == null) {
            this.failQueryMissing(rc);
            return;
        }
        try {
            variables = this.getVariablesFromQueryParam(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        this.executeOne(rc, new GraphQLQuery(query, rc.queryParams().get("operationName"), variables));
    }

    private void handlePost(RoutingContext rc, Buffer body) {
        Map<String, Object> variables;
        try {
            variables = this.getVariablesFromQueryParam(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        String query = rc.queryParams().get("query");
        if (query != null) {
            this.executeOne(rc, new GraphQLQuery(query, rc.queryParams().get("operationName"), variables));
            return;
        }
        switch (this.getContentType(rc)) {
            case "application/json": {
                this.handlePostJson(rc, body, rc.queryParams().get("operationName"), variables);
                break;
            }
            case "multipart/form-data": {
                this.handlePostMultipart(rc, rc.queryParams().get("operationName"), variables);
                break;
            }
            case "application/graphql": {
                this.executeOne(rc, new GraphQLQuery(body.toString(), rc.queryParams().get("operationName"), variables));
                break;
            }
            default: {
                rc.fail(415);
            }
        }
    }

    private void handlePostJson(RoutingContext rc, Buffer body, String operationName, Map<String, Object> variables) {
        GraphQLInput graphQLInput;
        try {
            graphQLInput = GraphQLInput.decode(body);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        if (graphQLInput instanceof GraphQLBatch) {
            this.handlePostBatch(rc, (GraphQLBatch)graphQLInput, operationName, variables);
        } else if (graphQLInput instanceof GraphQLQuery) {
            this.handlePostQuery(rc, (GraphQLQuery)graphQLInput, operationName, variables);
        } else {
            rc.fail(500);
        }
    }

    private void handlePostBatch(RoutingContext rc, GraphQLBatch batch, String operationName, Map<String, Object> variables) {
        if (!this.options.isRequestBatchingEnabled()) {
            rc.fail(400);
            return;
        }
        for (GraphQLQuery query : batch) {
            if (query.getQuery() == null) {
                this.failQueryMissing(rc);
                return;
            }
            if (operationName != null) {
                query.setOperationName(operationName);
            }
            if (variables == null) continue;
            query.setVariables(variables);
        }
        this.executeBatch(rc, batch);
    }

    private void executeBatch(RoutingContext rc, GraphQLBatch batch) {
        CompositeFuture all = StreamSupport.stream(batch.spliterator(), false).map(q -> this.execute(rc, (GraphQLQuery)q)).collect(Collectors.collectingAndThen(Collectors.toList(), CompositeFuture::all));
        all.map(cf -> new JsonArray(cf.list()).toBuffer()).onComplete(ar -> this.sendResponse(rc, (AsyncResult<Buffer>)ar));
    }

    private void handlePostQuery(RoutingContext rc, GraphQLQuery query, String operationName, Map<String, Object> variables) {
        if (query.getQuery() == null) {
            this.failQueryMissing(rc);
            return;
        }
        if (operationName != null) {
            query.setOperationName(operationName);
        }
        if (variables != null) {
            query.setVariables(variables);
        }
        this.executeOne(rc, query);
    }

    private void handlePostMultipart(RoutingContext rc, String operationName, Map<String, Object> variables) {
        GraphQLInput graphQLInput;
        if (!this.options.isRequestMultipartEnabled()) {
            rc.fail(415);
            return;
        }
        try {
            graphQLInput = this.parseMultipartAttributes(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        if (graphQLInput instanceof GraphQLBatch) {
            this.handlePostBatch(rc, (GraphQLBatch)graphQLInput, operationName, variables);
        } else if (graphQLInput instanceof GraphQLQuery) {
            this.handlePostQuery(rc, (GraphQLQuery)graphQLInput, operationName, variables);
        } else {
            rc.fail(500);
        }
    }

    private GraphQLInput parseMultipartAttributes(RoutingContext rc) {
        MultiMap attrs = rc.request().formAttributes();
        Map filesMap = (Map)Json.decodeValue((String)attrs.get("map"), Map.class);
        GraphQLInput graphQLInput = GraphQLInput.decode(Json.decodeValue((String)attrs.get("operations")));
        HashMap variablesMap = new HashMap();
        Iterable<GraphQLQuery> batch = graphQLInput instanceof GraphQLBatch ? (GraphQLBatch)graphQLInput : Collections.singletonList((GraphQLQuery)graphQLInput);
        int i = 0;
        for (GraphQLQuery query : batch) {
            HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
            variables.put("variables", query.getVariables());
            variablesMap.put(String.valueOf(i), variables);
            ++i;
        }
        for (Map.Entry entry : filesMap.entrySet()) {
            for (Object fullPath : (List)entry.getValue()) {
                Map variables;
                String[] path = ((String)fullPath).split("\\.");
                int end = path.length;
                int idx = -1;
                if (IS_NUMBER.matcher(path[end - 1]).matches()) {
                    idx = Integer.parseInt(path[end - 1]);
                    --end;
                }
                int start = 0;
                if (IS_NUMBER.matcher(path[0]).matches()) {
                    variables = (Map)variablesMap.get(path[0]);
                    ++start;
                } else {
                    variables = (Map)variablesMap.get("0");
                }
                String attr = path[--end];
                Map obj = variables;
                while (start < end) {
                    String token = path[start];
                    obj = (Map)obj.get(token);
                    ++start;
                }
                FileUpload file = rc.fileUploads().stream().filter(f -> f.name().equals(entry.getKey())).findFirst().orElse(null);
                if (file == null) continue;
                if (idx == -1) {
                    obj.put(attr, file);
                    continue;
                }
                ((List)obj.get(attr)).set(idx, file);
            }
        }
        return graphQLInput;
    }

    private void executeOne(RoutingContext rc, GraphQLQuery query) {
        this.execute(rc, query).map(JsonObject::toBuffer).onComplete(ar -> this.sendResponse(rc, (AsyncResult<Buffer>)ar));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<JsonObject> execute(RoutingContext rc, GraphQLQuery query) {
        Function<RoutingContext, Locale> l;
        Function<RoutingContext, DataLoaderRegistry> dlr;
        Function<RoutingContext, Object> qc;
        Map<String, Object> variables;
        ExecutionInput.Builder builder = ExecutionInput.newExecutionInput();
        builder.query(query.getQuery());
        String operationName = query.getOperationName();
        if (operationName != null) {
            builder.operationName(operationName);
        }
        if ((variables = query.getVariables()) != null) {
            builder.variables(variables);
        }
        GraphQLHandlerImpl graphQLHandlerImpl = this;
        synchronized (graphQLHandlerImpl) {
            qc = this.queryContextFactory;
        }
        builder.context(qc.apply(rc));
        GraphQLHandlerImpl graphQLHandlerImpl2 = this;
        synchronized (graphQLHandlerImpl2) {
            dlr = this.dataLoaderRegistryFactory;
        }
        DataLoaderRegistry registry = dlr.apply(rc);
        if (registry != null) {
            builder.dataLoaderRegistry(registry);
        }
        GraphQLHandlerImpl graphQLHandlerImpl3 = this;
        synchronized (graphQLHandlerImpl3) {
            l = this.localeFactory;
        }
        Locale locale = l.apply(rc);
        if (locale != null) {
            builder.locale(locale);
        }
        return Future.fromCompletionStage((CompletionStage)this.graphQL.executeAsync(builder.build()), (Context)rc.vertx().getOrCreateContext()).map(executionResult -> new JsonObject(executionResult.toSpecification()));
    }

    private String getContentType(RoutingContext rc) {
        String contentType = rc.parsedHeaders().contentType().value();
        return contentType.isEmpty() ? "application/json" : contentType.toLowerCase();
    }

    private Map<String, Object> getVariablesFromQueryParam(RoutingContext rc) throws Exception {
        String variablesParam = rc.queryParams().get("variables");
        if (variablesParam == null) {
            return null;
        }
        return new JsonObject(variablesParam).getMap();
    }

    private void sendResponse(RoutingContext rc, AsyncResult<Buffer> ar) {
        if (ar.succeeded()) {
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end((Buffer)ar.result());
        } else {
            rc.fail(ar.cause());
        }
    }

    private void failQueryMissing(RoutingContext rc) {
        rc.fail(400, (Throwable)new NoStackTraceThrowable("Query is missing"));
    }
}

