/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql;

import io.vertx.core.Promise;
import io.vertx.ext.web.handler.graphql.TriConsumer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;

public class VertxBatchLoader<K, V>
implements BatchLoaderWithContext<K, V> {
    private final TriConsumer<List<K>, BatchLoaderEnvironment, Promise<List<V>>> batchLoader;

    public VertxBatchLoader(TriConsumer<List<K>, BatchLoaderEnvironment, Promise<List<V>>> batchLoader) {
        this.batchLoader = batchLoader;
    }

    public CompletionStage<List<V>> load(List<K> keys, BatchLoaderEnvironment environment) {
        CompletableFuture cf = new CompletableFuture();
        Promise promise = Promise.promise();
        promise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                cf.complete((List)ar.result());
            } else {
                cf.completeExceptionally(ar.cause());
            }
        });
        this.batchLoader.accept(keys, environment, promise);
        return cf;
    }
}

