/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.vertx.core.Promise;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

public class VertxDataFetcher<T>
implements DataFetcher<CompletionStage<T>> {
    private final BiConsumer<DataFetchingEnvironment, Promise<T>> dataFetcher;

    public VertxDataFetcher(BiConsumer<DataFetchingEnvironment, Promise<T>> dataFetcher) {
        this.dataFetcher = dataFetcher;
    }

    public CompletionStage<T> get(DataFetchingEnvironment environment) throws Exception {
        CompletableFuture cf = new CompletableFuture();
        Promise promise = Promise.promise();
        promise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                cf.complete(ar.result());
            } else {
                cf.completeExceptionally(ar.cause());
            }
        });
        this.dataFetcher.accept(environment, promise);
        return cf;
    }
}

