/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.impl;

import graphql.ExecutionInput;
import graphql.GraphQL;
import io.vertx.core.Context;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.graphql.GraphQLHandler;
import io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions;
import io.vertx.ext.web.handler.graphql.GraphiQLOptions;
import io.vertx.ext.web.handler.graphql.impl.GraphQLBatch;
import io.vertx.ext.web.handler.graphql.impl.GraphQLInput;
import io.vertx.ext.web.handler.graphql.impl.GraphQLQuery;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataloader.DataLoaderRegistry;

public class GraphQLHandlerImpl
implements GraphQLHandler {
    private static final Function<RoutingContext, Object> DEFAULT_QUERY_CONTEXT_FACTORY = rc -> rc;
    private static final Function<RoutingContext, DataLoaderRegistry> DEFAULT_DATA_LOADER_REGISTRY_FACTORY = rc -> null;
    private static final Function<RoutingContext, MultiMap> DEFAULT_GRAPHIQL_REQUEST_HEADERS_FACTORY = rc -> null;
    private final GraphQL graphQL;
    private final GraphQLHandlerOptions options;
    private Function<RoutingContext, Object> queryContextFactory = DEFAULT_QUERY_CONTEXT_FACTORY;
    private Function<RoutingContext, DataLoaderRegistry> dataLoaderRegistryFactory = DEFAULT_DATA_LOADER_REGISTRY_FACTORY;
    private Function<RoutingContext, MultiMap> graphiQLRequestHeadersFactory = DEFAULT_GRAPHIQL_REQUEST_HEADERS_FACTORY;

    public GraphQLHandlerImpl(GraphQL graphQL, GraphQLHandlerOptions options) {
        Objects.requireNonNull(graphQL, "graphQL");
        Objects.requireNonNull(options, "options");
        this.graphQL = graphQL;
        this.options = options;
    }

    @Override
    public synchronized GraphQLHandler queryContext(Function<RoutingContext, Object> factory) {
        this.queryContextFactory = factory != null ? factory : DEFAULT_QUERY_CONTEXT_FACTORY;
        return this;
    }

    @Override
    public synchronized GraphQLHandler dataLoaderRegistry(Function<RoutingContext, DataLoaderRegistry> factory) {
        this.dataLoaderRegistryFactory = factory != null ? factory : DEFAULT_DATA_LOADER_REGISTRY_FACTORY;
        return this;
    }

    @Override
    public synchronized GraphQLHandler graphiQLRequestHeaders(Function<RoutingContext, MultiMap> factory) {
        this.graphiQLRequestHeadersFactory = factory != null ? factory : DEFAULT_GRAPHIQL_REQUEST_HEADERS_FACTORY;
        return this;
    }

    public void handle(RoutingContext rc) {
        HttpMethod method = rc.request().method();
        if (method == HttpMethod.GET) {
            this.handleGet(rc);
        } else if (method == HttpMethod.POST) {
            Buffer body = rc.getBody();
            if (body == null) {
                rc.request().bodyHandler(buffer -> this.handlePost(rc, (Buffer)buffer));
            } else {
                this.handlePost(rc, body);
            }
        } else {
            rc.fail(405);
        }
    }

    private void handleGet(RoutingContext rc) {
        Map<String, Object> variablesFromQueryParam;
        Stream<String> accept;
        if (this.options.getGraphiQLOptions().isEnabled() && (accept = rc.parsedHeaders().accept().stream().map(MIMEHeader::subComponent)).anyMatch(sub -> "html".equalsIgnoreCase((String)sub))) {
            this.handleGraphiQL(rc);
            return;
        }
        String q = this.getQueryFromQueryParam(rc);
        if (q == null) {
            this.failQueryMissing(rc);
            return;
        }
        GraphQLQuery query = new GraphQLQuery().setQuery(q);
        try {
            variablesFromQueryParam = this.getVariablesFromQueryParam(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        query.setVariables(variablesFromQueryParam);
        this.executeOne(rc, query);
    }

    private void handleGraphiQL(RoutingContext rc) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream stream = classLoader.getResourceAsStream("io/vertx/ext/web/handler/graphql/graphiql.html");){
            String source = new Scanner(stream, "UTF-8").useDelimiter("\\A").next();
            String replacement = this.replacement(rc);
            String html = replacement.isEmpty() ? source : source.replace("<!-- VERTX-WEB-GRAPHIQL-REPLACEMENT -->", replacement);
            rc.response().end(html);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String replacement(RoutingContext rc) {
        Function<RoutingContext, MultiMap> rh;
        GraphiQLOptions graphiQLOptions = this.options.getGraphiQLOptions();
        StringBuilder builder = new StringBuilder();
        if (graphiQLOptions.getGraphQLUri() != null) {
            builder.append("var graphQLUri = ").append(graphiQLOptions.getGraphQLUri()).append(";");
        }
        MultiMap headers = MultiMap.caseInsensitiveMultiMap();
        Map<String, String> fixedHeaders = graphiQLOptions.getHeaders();
        if (fixedHeaders != null) {
            fixedHeaders.forEach((arg_0, arg_1) -> ((MultiMap)headers).add(arg_0, arg_1));
        }
        GraphQLHandlerImpl graphQLHandlerImpl = this;
        synchronized (graphQLHandlerImpl) {
            rh = this.graphiQLRequestHeadersFactory;
        }
        MultiMap dynamicHeaders = rh.apply(rc);
        if (dynamicHeaders != null) {
            headers.addAll(dynamicHeaders);
        }
        if (!headers.isEmpty()) {
            headers.forEach(header -> builder.append("headers['").append((String)header.getKey()).append("'] = '").append((String)header.getValue()).append("';"));
        }
        if (graphiQLOptions.getQuery() != null) {
            builder.append("parameters['query'] = '").append(graphiQLOptions.getQuery()).append("';");
        }
        if (graphiQLOptions.getVariables() != null) {
            builder.append("parameters['variables'] = '").append(graphiQLOptions.getVariables().encode()).append("';");
        }
        return builder.toString();
    }

    private void handlePost(RoutingContext rc, Buffer body) {
        Map<String, Object> variablesFromQueryParm;
        try {
            variablesFromQueryParm = this.getVariablesFromQueryParam(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        String queryFromQueryParam = this.getQueryFromQueryParam(rc);
        if (queryFromQueryParam != null) {
            this.executeOne(rc, new GraphQLQuery().setQuery(queryFromQueryParam).setVariables(variablesFromQueryParm));
            return;
        }
        switch (this.getContentType(rc)) {
            case "application/json": {
                this.handlePostJson(rc, body, variablesFromQueryParm);
                break;
            }
            case "application/graphql": {
                this.executeOne(rc, new GraphQLQuery().setQuery(body.toString()).setVariables(variablesFromQueryParm));
                break;
            }
            default: {
                rc.fail(415);
            }
        }
    }

    private void handlePostJson(RoutingContext rc, Buffer body, Map<String, Object> variablesFromQueryParm) {
        GraphQLInput graphQLInput;
        try {
            graphQLInput = (GraphQLInput)Json.decodeValue((Buffer)body, GraphQLInput.class);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        if (graphQLInput instanceof GraphQLBatch) {
            this.handlePostBatch(rc, (GraphQLBatch)graphQLInput, variablesFromQueryParm);
        } else if (graphQLInput instanceof GraphQLQuery) {
            this.handlePostQuery(rc, (GraphQLQuery)graphQLInput, variablesFromQueryParm);
        } else {
            rc.fail(500);
        }
    }

    private void handlePostBatch(RoutingContext rc, GraphQLBatch batch, Map<String, Object> variablesFromQueryParm) {
        if (!this.options.isRequestBatchingEnabled()) {
            rc.fail(400);
            return;
        }
        for (GraphQLQuery query : batch) {
            if (query.getQuery() == null) {
                this.failQueryMissing(rc);
                return;
            }
            if (query.getVariables() != null) continue;
            query.setVariables(variablesFromQueryParm);
        }
        this.executeBatch(rc, batch);
    }

    private void executeBatch(RoutingContext rc, GraphQLBatch batch) {
        List<CompletableFuture> results = batch.stream().map(q -> this.execute(rc, (GraphQLQuery)q)).collect(Collectors.toList());
        CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).whenCompleteAsync((v, throwable) -> {
            JsonArray jsonArray = results.stream().map(CompletableFuture::join).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
            this.sendResponse(rc, jsonArray.toBuffer(), (Throwable)throwable);
        }, this.contextExecutor(rc));
    }

    private void handlePostQuery(RoutingContext rc, GraphQLQuery query, Map<String, Object> variablesFromQueryParm) {
        if (query.getQuery() == null) {
            this.failQueryMissing(rc);
            return;
        }
        if (query.getVariables() == null) {
            query.setVariables(variablesFromQueryParm);
        }
        this.executeOne(rc, query);
    }

    private void executeOne(RoutingContext rc, GraphQLQuery query) {
        ((CompletableFuture)this.execute(rc, query).thenApply(JsonObject::toBuffer)).whenComplete((buffer, throwable) -> this.sendResponse(rc, (Buffer)buffer, (Throwable)throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<JsonObject> execute(RoutingContext rc, GraphQLQuery query) {
        Function<RoutingContext, DataLoaderRegistry> dlr;
        Function<RoutingContext, Object> qc;
        ExecutionInput.Builder builder = ExecutionInput.newExecutionInput();
        builder.query(query.getQuery());
        Map<String, Object> variables = query.getVariables();
        if (variables != null) {
            builder.variables(variables);
        }
        GraphQLHandlerImpl graphQLHandlerImpl = this;
        synchronized (graphQLHandlerImpl) {
            qc = this.queryContextFactory;
        }
        builder.context(qc.apply(rc));
        GraphQLHandlerImpl graphQLHandlerImpl2 = this;
        synchronized (graphQLHandlerImpl2) {
            dlr = this.dataLoaderRegistryFactory;
        }
        DataLoaderRegistry registry = dlr.apply(rc);
        if (registry != null) {
            builder.dataLoaderRegistry(registry);
        }
        return this.graphQL.executeAsync(builder.build()).thenApplyAsync(executionResult -> new JsonObject(executionResult.toSpecification()), this.contextExecutor(rc));
    }

    private String getContentType(RoutingContext rc) {
        String contentType = rc.request().headers().get(HttpHeaders.CONTENT_TYPE);
        return contentType == null ? "application/json" : contentType.toLowerCase();
    }

    private String getQueryFromQueryParam(RoutingContext rc) {
        return rc.queryParams().get("query");
    }

    private Map<String, Object> getVariablesFromQueryParam(RoutingContext rc) throws Exception {
        String variablesParam = rc.queryParams().get("variables");
        if (variablesParam == null) {
            return null;
        }
        return new JsonObject(variablesParam).getMap();
    }

    private void sendResponse(RoutingContext rc, Buffer buffer, Throwable throwable) {
        if (throwable == null) {
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(buffer);
        } else {
            rc.fail(throwable);
        }
    }

    private void failQueryMissing(RoutingContext rc) {
        rc.fail(400, (Throwable)new NoStackTraceThrowable("Query is missing"));
    }

    private Executor contextExecutor(RoutingContext rc) {
        Context ctx = rc.vertx().getOrCreateContext();
        return command -> ctx.runOnContext(v -> command.run());
    }
}

