/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.common.WebEnvironment;
import io.vertx.ext.web.handler.graphql.GraphiQLOptionsConverter;
import java.util.HashMap;
import java.util.Map;

@DataObject(generateConverter=true)
public class GraphiQLOptions {
    public static final boolean DEFAULT_ENABLED = WebEnvironment.development();
    private boolean enabled = DEFAULT_ENABLED;
    private String graphQLUri;
    private Map<String, String> headers;
    private String query;
    private JsonObject variables;

    public GraphiQLOptions() {
    }

    public GraphiQLOptions(GraphiQLOptions other) {
        this.enabled = other.enabled;
        this.graphQLUri = other.graphQLUri;
        this.headers = other.headers == null ? null : new HashMap<String, String>(other.headers);
        this.query = other.query;
        this.variables = other.variables == null ? null : other.variables.copy();
    }

    public GraphiQLOptions(JsonObject json) {
        this();
        GraphiQLOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        GraphiQLOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public GraphiQLOptions setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getGraphQLUri() {
        return this.graphQLUri;
    }

    public GraphiQLOptions setGraphQLUri(String graphQLUri) {
        this.graphQLUri = graphQLUri;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public GraphiQLOptions setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public GraphiQLOptions setQuery(String query) {
        this.query = query;
        return this;
    }

    public JsonObject getVariables() {
        return this.variables;
    }

    public GraphiQLOptions setVariables(JsonObject variables) {
        this.variables = variables;
        return this;
    }
}

