/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import io.vertx.ext.web.multipart.FormDataPart;
import io.vertx.ext.web.multipart.MultipartForm;
import java.io.File;

public class MultipartFormUpload
implements ReadStream<Buffer> {
    private static final UnpooledByteBufAllocator ALLOC = new UnpooledByteBufAllocator(false);
    private DefaultFullHttpRequest request;
    private HttpPostRequestEncoder encoder;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private InboundBuffer<Object> pending;
    private boolean ended;
    private final Context context;

    public MultipartFormUpload(Context context, MultipartForm parts, boolean multipart, HttpPostRequestEncoder.EncoderMode encoderMode) throws Exception {
        this.context = context;
        this.pending = new InboundBuffer(context).handler(this::handleChunk).drainHandler(v -> this.run()).pause();
        this.request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        this.encoder = new HttpPostRequestEncoder((HttpDataFactory)new DefaultHttpDataFactory(16384L), (HttpRequest)this.request, multipart, HttpConstants.DEFAULT_CHARSET, encoderMode);
        for (FormDataPart formDataPart : parts) {
            if (formDataPart.isAttribute()) {
                this.encoder.addBodyAttribute(formDataPart.name(), formDataPart.value());
                continue;
            }
            this.encoder.addBodyFileUpload(formDataPart.name(), formDataPart.filename(), new File(formDataPart.pathname()), formDataPart.mediaType(), formDataPart.isText().booleanValue());
        }
        this.encoder.finalizeRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChunk(Object item) {
        Object handler;
        MultipartFormUpload multipartFormUpload = this;
        synchronized (multipartFormUpload) {
            if (item instanceof Buffer) {
                handler = this.dataHandler;
            } else if (item instanceof Throwable) {
                handler = this.exceptionHandler;
            } else if (item == InboundBuffer.END_SENTINEL) {
                handler = this.endHandler;
                item = null;
            } else {
                return;
            }
        }
        handler.handle(item);
    }

    public void run() {
        if (Vertx.currentContext() != this.context) {
            this.context.runOnContext(v -> this.run());
            return;
        }
        while (!this.ended) {
            if (this.encoder.isChunked()) {
                try {
                    HttpContent chunk = this.encoder.readChunk((ByteBufAllocator)ALLOC);
                    ByteBuf content = chunk.content();
                    Buffer buff = Buffer.buffer((ByteBuf)content);
                    boolean writable = this.pending.write((Object)buff);
                    if (this.encoder.isEndOfInput()) {
                        this.ended = true;
                        this.request = null;
                        this.encoder = null;
                        this.pending.write(InboundBuffer.END_SENTINEL);
                        continue;
                    }
                    if (writable) continue;
                }
                catch (Exception e) {
                    this.ended = true;
                    this.request = null;
                    this.encoder = null;
                    this.pending.write((Object)e);
                }
                break;
            }
            ByteBuf content = this.request.content();
            Buffer buffer = Buffer.buffer((ByteBuf)content);
            this.request = null;
            this.encoder = null;
            this.pending.write((Object)buffer);
            this.ended = true;
            this.pending.write(InboundBuffer.END_SENTINEL);
        }
    }

    public MultiMap headers() {
        return new HeadersAdaptor(this.request.headers());
    }

    public synchronized MultipartFormUpload exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized MultipartFormUpload handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    public synchronized MultipartFormUpload pause() {
        this.pending.pause();
        return this;
    }

    public ReadStream<Buffer> fetch(long amount) {
        this.pending.fetch(amount);
        return this;
    }

    public synchronized MultipartFormUpload resume() {
        this.pending.resume();
        return this;
    }

    public synchronized MultipartFormUpload endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }
}

