/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.service.impl;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.service.OpenAPIRouterHandler;
import io.vertx.ext.web.api.service.ServiceRequest;
import io.vertx.ext.web.api.service.ServiceResponse;
import io.vertx.ext.web.openapi.router.internal.handler.EventbusHandler;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.validation.RequestParameter;
import io.vertx.openapi.validation.ResponseValidator;
import io.vertx.openapi.validation.ValidatableResponse;
import io.vertx.openapi.validation.ValidatedRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;

public class OpenAPIRouterHandlerImpl
extends EventbusHandler
implements OpenAPIRouterHandler {
    private final BiFunction<Operation, RoutingContext, JsonObject> extraPayloadMapper;

    public OpenAPIRouterHandlerImpl(EventBus eventBus, String address, DeliveryOptions deliveryOptions, BiFunction<Operation, RoutingContext, JsonObject> extraPayloadMapper, ResponseValidator validator) {
        super(eventBus, address, deliveryOptions, validator);
        this.extraPayloadMapper = extraPayloadMapper;
    }

    protected Future<JsonObject> transformRequest(ValidatedRequest request, RoutingContext routingContext, Operation operation) {
        JsonObject params = this.buildParametersObject(request);
        JsonObject userPrincipal = Optional.ofNullable(routingContext.user().get()).map(User::principal).orElse(null);
        ServiceRequest sr = new ServiceRequest(params, routingContext.request().headers(), userPrincipal, this.extraPayloadMapper.apply(operation, routingContext));
        return Future.succeededFuture((Object)new JsonObject().put("context", (Object)sr.toJson()));
    }

    protected Future<ValidatableResponse> transformResponse(Message<JsonObject> ebResponse, Operation operation) {
        ServiceResponse serviceResponse = new ServiceResponse((JsonObject)ebResponse.body());
        int statusCode = serviceResponse.getStatusCode();
        HashMap headers = new HashMap();
        serviceResponse.getHeaders().forEach(headers::put);
        Buffer body = serviceResponse.getPayload();
        if (body == null) {
            return Future.succeededFuture((Object)ValidatableResponse.create((int)statusCode, headers));
        }
        String contentType = (String)headers.get(HttpHeaders.CONTENT_TYPE.toString());
        if (contentType == null || contentType.isEmpty()) {
            String msg = "Content-Type header is required, when response contains a body.";
            return Future.failedFuture((Throwable)new IllegalArgumentException(msg));
        }
        return Future.succeededFuture((Object)ValidatableResponse.create((int)statusCode, headers, (Buffer)body, (String)contentType));
    }

    private JsonObject buildParametersObject(ValidatedRequest vr) {
        JsonObject params = new JsonObject();
        params.put("header", this.transformRequestParameters(vr.getHeaders()));
        params.put("cookie", this.transformRequestParameters(vr.getCookies()));
        params.put("query", this.transformRequestParameters(vr.getQuery()));
        params.put("path", this.transformRequestParameters(vr.getPathParameters()));
        params.put("body", vr.getBody().get());
        return params;
    }

    private Map<String, Object> transformRequestParameters(Map<String, RequestParameter> params) {
        if (params == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> mapToReturn = new HashMap<String, Object>(params.size());
        params.forEach((k, v) -> mapToReturn.put((String)k, v.get()));
        return mapToReturn;
    }
}

