require 'vertx-web-api-contract/request_parameter'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.api.RequestParameters
module VertxWebApiContract
  #  Container for request parameters
  class RequestParameters
    # @private
    # @param j_del [::VertxWebApiContract::RequestParameters] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebApiContract::RequestParameters] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RequestParameters
    end
    def @@j_api_type.wrap(obj)
      RequestParameters.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebApi::RequestParameters.java_class
    end
    #  Get list of all parameter names inside path
    # @return [Array<String>] 
    def path_parameters_names
      if !block_given?
        return @j_del.java_method(:pathParametersNames, []).call().to_a.map { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling path_parameters_names()"
    end
    #  Get path parameter by name
    # @param [String] name Parameter name
    # @return [::VertxWebApiContract::RequestParameter] 
    def path_parameter(name=nil)
      if name.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pathParameter, [Java::java.lang.String.java_class]).call(name),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling path_parameter(#{name})"
    end
    #  Get list of all parameter names inside query
    # @return [Array<String>] 
    def query_parameters_names
      if !block_given?
        return @j_del.java_method(:queryParametersNames, []).call().to_a.map { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling query_parameters_names()"
    end
    #  Get query parameter by name
    # @param [String] name Parameter name
    # @return [::VertxWebApiContract::RequestParameter] 
    def query_parameter(name=nil)
      if name.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:queryParameter, [Java::java.lang.String.java_class]).call(name),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling query_parameter(#{name})"
    end
    #  Get list of all parameter names inside header
    # @return [Array<String>] 
    def header_parameters_names
      if !block_given?
        return @j_del.java_method(:headerParametersNames, []).call().to_a.map { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling header_parameters_names()"
    end
    #  Get header parameter by name
    # @param [String] name Parameter name
    # @return [::VertxWebApiContract::RequestParameter] 
    def header_parameter(name=nil)
      if name.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headerParameter, [Java::java.lang.String.java_class]).call(name),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling header_parameter(#{name})"
    end
    #  Get list of all parameter names inside cookie
    # @return [Array<String>] 
    def cookie_parameters_names
      if !block_given?
        return @j_del.java_method(:cookieParametersNames, []).call().to_a.map { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling cookie_parameters_names()"
    end
    #  Get cookie parameter by name
    # @param [String] name Parameter name
    # @return [::VertxWebApiContract::RequestParameter] 
    def cookie_parameter(name=nil)
      if name.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cookieParameter, [Java::java.lang.String.java_class]).call(name),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling cookie_parameter(#{name})"
    end
    #  Get list of all parameter names inside body form
    # @return [Array<String>] 
    def form_parameters_names
      if !block_given?
        return @j_del.java_method(:formParametersNames, []).call().to_a.map { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling form_parameters_names()"
    end
    #  Get form parameter by name
    # @param [String] name Parameter name
    # @return [::VertxWebApiContract::RequestParameter] 
    def form_parameter(name=nil)
      if name.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:formParameter, [Java::java.lang.String.java_class]).call(name),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling form_parameter(#{name})"
    end
    #  Return request body
    # @return [::VertxWebApiContract::RequestParameter] 
    def body
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:body, []).call(),::VertxWebApiContract::RequestParameter)
      end
      raise ArgumentError, "Invalid arguments when calling body()"
    end
  end
end
