require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.api.validation.CustomValidator
module VertxWebApiContract
  #  This interface is used to add custom <b>synchronous</b> functions inside validation process. You can add it in
  #  {::VertxWebApiContract::HTTPRequestValidationHandler}.
  class CustomValidator
    # @private
    # @param j_del [::VertxWebApiContract::CustomValidator] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebApiContract::CustomValidator] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CustomValidator
    end
    def @@j_api_type.wrap(obj)
      CustomValidator.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebApiValidation::CustomValidator.java_class
    end
    #  This function have to be <b>synchronous</b>. It doesn't return nothing if validation succedes, otherwise it
    #  throws ValidationException.
    #  <br/>
    #  <b>Don't call routingContext.next() or routingContext.fail() from this function</b>
    # @param [::VertxWeb::RoutingContext] routingContext the actual routing context
    # @return [void]
    def validate(routingContext=nil)
      if routingContext.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:validate, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(routingContext.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling validate(#{routingContext})"
    end
  end
end
