/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-api-contract-js/request_parameters */
var utils = require('vertx-js/util/utils');
var RequestParameter = require('vertx-web-api-contract-js/request_parameter');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JRequestParameters = Java.type('io.vertx.ext.web.api.RequestParameters');

/**
 Container for request parameters

 @class
*/
var RequestParameters = function(j_val) {

  var j_requestParameters = j_val;
  var that = this;

  /**
   Get list of all parameter names inside path

   @public

   @return {Array.<string>} 
   */
  this.pathParametersNames = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameters["pathParametersNames()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get path parameter by name

   @public
   @param name {string} Parameter name 
   @return {RequestParameter} 
   */
  this.pathParameter = function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["pathParameter(java.lang.String)"](name));
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get list of all parameter names inside query

   @public

   @return {Array.<string>} 
   */
  this.queryParametersNames = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameters["queryParametersNames()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get query parameter by name

   @public
   @param name {string} Parameter name 
   @return {RequestParameter} 
   */
  this.queryParameter = function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["queryParameter(java.lang.String)"](name));
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get list of all parameter names inside header

   @public

   @return {Array.<string>} 
   */
  this.headerParametersNames = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameters["headerParametersNames()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get header parameter by name

   @public
   @param name {string} Parameter name 
   @return {RequestParameter} 
   */
  this.headerParameter = function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["headerParameter(java.lang.String)"](name));
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get list of all parameter names inside cookie

   @public

   @return {Array.<string>} 
   */
  this.cookieParametersNames = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameters["cookieParametersNames()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get cookie parameter by name

   @public
   @param name {string} Parameter name 
   @return {RequestParameter} 
   */
  this.cookieParameter = function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["cookieParameter(java.lang.String)"](name));
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get list of all parameter names inside body form

   @public

   @return {Array.<string>} 
   */
  this.formParametersNames = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_requestParameters["formParametersNames()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get form parameter by name

   @public
   @param name {string} Parameter name 
   @return {RequestParameter} 
   */
  this.formParameter = function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["formParameter(java.lang.String)"](name));
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Return request body

   @public

   @return {RequestParameter} 
   */
  this.body = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(RequestParameter, j_requestParameters["body()"]());
    } else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_requestParameters;
};

RequestParameters._jclass = utils.getJavaClass("io.vertx.ext.web.api.RequestParameters");
RequestParameters._jtype = {
  accept: function(obj) {
    return RequestParameters._jclass.isInstance(obj._jdel);
  },
  wrap: function(jdel) {
    var obj = Object.create(RequestParameters.prototype, {});
    RequestParameters.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
RequestParameters._create = function(jdel) {
  var obj = Object.create(RequestParameters.prototype, {});
  RequestParameters.apply(obj, arguments);
  return obj;
}
module.exports = RequestParameters;