/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-api-contract-js/open_api3_router_factory */
var utils = require('vertx-js/util/utils');
var RouterFactory = require('vertx-web-api-contract-js/router_factory');
var Vertx = require('vertx-js/vertx');
var Router = require('vertx-web-js/router');
var RoutingContext = require('vertx-web-js/routing_context');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JOpenAPI3RouterFactory = Java.type('io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory');
var RouterFactoryOptions = Java.type('io.vertx.ext.web.api.contract.RouterFactoryOptions');

/**
 Interface for OpenAPI3RouterFactory. <br/>
 @class
*/
var OpenAPI3RouterFactory = function(j_val) {

  var j_openAPI3RouterFactory = j_val;
  var that = this;
  RouterFactory.call(this, j_val);

  /**
   Mount to paths that have to follow a security schema a security handler

   @public
   @param securitySchemaName {string} 
   @param handler {function} 
   @return {RouterFactory} 
   */
  this.addSecurityHandler = function(securitySchemaName, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_openAPI3RouterFactory["addSecurityHandler(java.lang.String,io.vertx.core.Handler)"](securitySchemaName, function(jVal) {
      handler(utils.convReturnVertxGen(RoutingContext, jVal));
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add an handler to a path with a method. If combination path/method is not available in
   specification, it will throw a . Deprecated in favour of
   operation id

   @public
   @param method {Object} 
   @param path {string} 
   @param handler {function} 
   @return {RouterFactory} 
   */
  this.addHandler = function(method, path, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_openAPI3RouterFactory["addHandler(io.vertx.core.http.HttpMethod,java.lang.String,io.vertx.core.Handler)"](io.vertx.core.http.HttpMethod.valueOf(method), path, function(jVal) {
      handler(utils.convReturnVertxGen(RoutingContext, jVal));
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a failure handler to a path with a method. If combination path/method is not available in
   specification, it will throw a . Deprecated in favour of
   operation id

   @public
   @param method {Object} 
   @param path {string} 
   @param failureHandler {function} 
   @return {RouterFactory} 
   */
  this.addFailureHandler = function(method, path, failureHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_openAPI3RouterFactory["addFailureHandler(io.vertx.core.http.HttpMethod,java.lang.String,io.vertx.core.Handler)"](io.vertx.core.http.HttpMethod.valueOf(method), path, function(jVal) {
      failureHandler(utils.convReturnVertxGen(RoutingContext, jVal));
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Override options

   @public
   @param options {Object} 
   @return {RouterFactory} 
   */
  this.setOptions = function(options) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_openAPI3RouterFactory["setOptions(io.vertx.ext.web.api.contract.RouterFactoryOptions)"](options != null ? new RouterFactoryOptions(new JsonObject(Java.asJSONCompatible(options))) : null);
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get options of router factory. For more info 

   @public

   @return {Object} 
   */
  this.getOptions = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnDataObject(j_openAPI3RouterFactory["getOptions()"]());
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Deprecated. Instantiate 
   and load it using 

   @public
   @param handler {function} 
   @return {RouterFactory} 
   */
  this.setValidationFailureHandler = function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_openAPI3RouterFactory["setValidationFailureHandler(io.vertx.core.Handler)"](function(jVal) {
      handler(utils.convReturnVertxGen(RoutingContext, jVal));
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Deprecated. Instantiate 
   and load it using 

   @public
   @param enable {boolean} 
   @return {RouterFactory} 
   */
  this.enableValidationFailureHandler = function(enable) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_openAPI3RouterFactory["enableValidationFailureHandler(boolean)"](enable);
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Deprecated. Instantiate 
   and load it using 

   @public
   @param enable {boolean} 
   @return {RouterFactory} 
   */
  this.mountOperationsWithoutHandlers = function(enable) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_openAPI3RouterFactory["mountOperationsWithoutHandlers(boolean)"](enable);
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
   without assigned handlers<br/>
   <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.

   @public

   @return {Router} 
   */
  this.getRouter = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Router, j_openAPI3RouterFactory["getRouter()"]());
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a particular scope validator. The main security schema will not be called if a specific scope validator is
   configured

   @public
   @param securitySchemaName {string} 
   @param scopeName {string} 
   @param handler {function} 
   @return {OpenAPI3RouterFactory} this factory
   */
  this.addSecuritySchemaScopeValidator = function(securitySchemaName, scopeName, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_openAPI3RouterFactory["addSecuritySchemaScopeValidator(java.lang.String,java.lang.String,io.vertx.core.Handler)"](securitySchemaName, scopeName, function(jVal) {
      handler(utils.convReturnVertxGen(RoutingContext, jVal));
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add an handler by operation_id field in Operation object

   @public
   @param operationId {string} 
   @param handler {function} 
   @return {OpenAPI3RouterFactory} this factory
   */
  this.addHandlerByOperationId = function(operationId, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_openAPI3RouterFactory["addHandlerByOperationId(java.lang.String,io.vertx.core.Handler)"](operationId, function(jVal) {
      handler(utils.convReturnVertxGen(RoutingContext, jVal));
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a failure handler by operation_id field in Operation object

   @public
   @param operationId {string} 
   @param failureHandler {function} 
   @return {OpenAPI3RouterFactory} this factory
   */
  this.addFailureHandlerByOperationId = function(operationId, failureHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_openAPI3RouterFactory["addFailureHandlerByOperationId(java.lang.String,io.vertx.core.Handler)"](operationId, function(jVal) {
      failureHandler(utils.convReturnVertxGen(RoutingContext, jVal));
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_openAPI3RouterFactory;
};

OpenAPI3RouterFactory._jclass = utils.getJavaClass("io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory");
OpenAPI3RouterFactory._jtype = {
  accept: function(obj) {
    return OpenAPI3RouterFactory._jclass.isInstance(obj._jdel);
  },
  wrap: function(jdel) {
    var obj = Object.create(OpenAPI3RouterFactory.prototype, {});
    OpenAPI3RouterFactory.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
OpenAPI3RouterFactory._create = function(jdel) {
  var obj = Object.create(OpenAPI3RouterFactory.prototype, {});
  OpenAPI3RouterFactory.apply(obj, arguments);
  return obj;
}
/**
 Create a new OpenAPI3RouterFactory

 @memberof module:vertx-web-api-contract-js/open_api3_router_factory
 @param vertx {Vertx} 
 @param url {string} location of your spec. It can be an absolute path, a local path or remote url (with HTTP protocol) 
 @param handler {function} When specification is loaded, this handler will be called with AsyncResult<OpenAPI3RouterFactory> 
 */
OpenAPI3RouterFactory.create = function(vertx, url, handler) {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
    JOpenAPI3RouterFactory["create(io.vertx.core.Vertx,java.lang.String,io.vertx.core.Handler)"](vertx._jdel, url, function(ar) {
    if (ar.succeeded()) {
      handler(utils.convReturnVertxGen(OpenAPI3RouterFactory, ar.result()), null);
    } else {
      handler(null, ar.cause());
    }
  });
  } else throw new TypeError('function invoked with invalid arguments');
};

/**

 @memberof module:vertx-web-api-contract-js/open_api3_router_factory
 @param vertx {Vertx} 
 @param url {string} 
 @param handler {function} 
 */
OpenAPI3RouterFactory.createRouterFactoryFromFile = function(vertx, url, handler) {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
    JOpenAPI3RouterFactory["createRouterFactoryFromFile(io.vertx.core.Vertx,java.lang.String,io.vertx.core.Handler)"](vertx._jdel, url, function(ar) {
    if (ar.succeeded()) {
      handler(utils.convReturnVertxGen(OpenAPI3RouterFactory, ar.result()), null);
    } else {
      handler(null, ar.cause());
    }
  });
  } else throw new TypeError('function invoked with invalid arguments');
};

/**

 @memberof module:vertx-web-api-contract-js/open_api3_router_factory
 @param vertx {Vertx} 
 @param url {string} 
 @param handler {function} 
 */
OpenAPI3RouterFactory.createRouterFactoryFromURL = function(vertx, url, handler) {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
    JOpenAPI3RouterFactory["createRouterFactoryFromURL(io.vertx.core.Vertx,java.lang.String,io.vertx.core.Handler)"](vertx._jdel, url, function(ar) {
    if (ar.succeeded()) {
      handler(utils.convReturnVertxGen(OpenAPI3RouterFactory, ar.result()), null);
    } else {
      handler(null, ar.cause());
    }
  });
  } else throw new TypeError('function invoked with invalid arguments');
};

module.exports = OpenAPI3RouterFactory;