/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3.impl;

import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.contract.RouterFactoryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class SecurityHandlersStore {
    private final Map<SecurityRequirementKey, Handler<RoutingContext>> securityHandlers = new HashMap<SecurityRequirementKey, Handler<RoutingContext>>();

    SecurityHandlersStore() {
    }

    protected void addSecurityRequirement(String name, String scope, Handler<RoutingContext> handler) {
        this.securityHandlers.put(new SecurityRequirementKey(name, scope), handler);
    }

    protected void addSecurityRequirement(String name, Handler<RoutingContext> handler) {
        this.securityHandlers.put(new SecurityRequirementKey(name), handler);
    }

    private Handler<RoutingContext> mapWithFail(SecurityRequirementKey k) throws RouterFactoryException {
        if (k.hasScope()) {
            return Optional.ofNullable(this.securityHandlers.get(k) != null ? this.securityHandlers.get(k) : this.securityHandlers.get(k.cloneWithoutScope())).orElseThrow(() -> RouterFactoryException.createMissingSecurityHandler(k.getName(), k.getScope()));
        }
        return Optional.ofNullable(this.securityHandlers.get(k)).orElseThrow(() -> RouterFactoryException.createMissingSecurityHandler(k.getName()));
    }

    private Handler<RoutingContext> mapWithoutFail(SecurityRequirementKey k) {
        if (k.hasScope()) {
            return Optional.ofNullable(this.securityHandlers.get(k)).orElseGet(() -> this.securityHandlers.get(k.cloneWithoutScope()));
        }
        return this.securityHandlers.get(k);
    }

    protected List<Handler<RoutingContext>> solveSecurityHandlers(List<SecurityRequirement> untraslatedKeys, boolean failOnNotFound) {
        List<SecurityRequirementKey> keys = this.translateRequirements(untraslatedKeys);
        if (keys != null) {
            if (failOnNotFound) {
                return keys.stream().map(this::mapWithFail).collect(Collectors.toList());
            }
            return keys.stream().map(this::mapWithoutFail).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return new ArrayList<Handler<RoutingContext>>();
    }

    private List<SecurityRequirementKey> translateRequirements(List<SecurityRequirement> keys) {
        if (keys != null) {
            return keys.stream().flatMap(m -> m.entrySet().stream().flatMap(e -> {
                if (e.getValue() == null || ((List)e.getValue()).size() == 0) {
                    return Stream.of(new SecurityRequirementKey((String)e.getKey()));
                }
                return ((List)e.getValue()).stream().map(s -> new SecurityRequirementKey((String)e.getKey(), (String)s));
            })).collect(Collectors.toList());
        }
        return new ArrayList<SecurityRequirementKey>();
    }

    private class SecurityRequirementKey {
        private String name;
        private String oauth2Scope;

        public SecurityRequirementKey(String name, String oauth2Scope) {
            this.name = name;
            this.oauth2Scope = oauth2Scope;
        }

        public SecurityRequirementKey(String name) {
            this(name, null);
        }

        public String getName() {
            return this.name;
        }

        public String getScope() {
            return this.oauth2Scope;
        }

        public boolean hasScope() {
            return this.oauth2Scope != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SecurityRequirementKey that = (SecurityRequirementKey)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.oauth2Scope != null ? this.oauth2Scope.equals(that.oauth2Scope) : that.oauth2Scope == null;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.oauth2Scope != null ? this.oauth2Scope.hashCode() : 0);
            return result;
        }

        private SecurityRequirementKey cloneWithoutScope() {
            return new SecurityRequirementKey(this.getName());
        }
    }
}

