/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3.impl;

import io.swagger.v3.oas.models.parameters.Parameter;
import io.vertx.ext.web.api.contract.RouterFactoryException;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenApi3Utils;
import io.vertx.ext.web.api.contract.openapi3.impl.RegexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OpenAPI3PathResolver {
    String oasPath;
    List<Parameter> parameters;
    Pattern resolvedPattern;
    Map<String, String> mappedGroups;
    public static final Pattern OAS_PATH_PARAMETERS_PATTERN = Pattern.compile("\\{{1}[.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*\\}{1}");
    public static final Pattern ILLEGAL_PATH_MATCHER = Pattern.compile("\\{[^\\/]*\\/[^\\/]*\\}");
    private boolean shouldThreatDotAsReserved;

    public OpenAPI3PathResolver(String oasPath, List<Parameter> parameters) {
        this.oasPath = oasPath;
        this.parameters = parameters != null ? parameters.stream().filter(parameter -> parameter.getIn().equals("path")).collect(Collectors.toList()) : new ArrayList<Parameter>();
        this.shouldThreatDotAsReserved = this.hasParameterWithStyle("label");
        this.mappedGroups = new HashMap<String, String>();
    }

    public Optional<Pattern> solve() {
        if (ILLEGAL_PATH_MATCHER.matcher(this.oasPath).matches()) {
            throw new RouterFactoryException("Path template not supported", RouterFactoryException.ErrorType.INVALID_SPEC_PATH);
        }
        Matcher parametersMatcher = OAS_PATH_PARAMETERS_PATTERN.matcher(this.oasPath);
        if (!this.parameters.isEmpty() && parametersMatcher.find()) {
            StringBuilder regex = new StringBuilder();
            int lastMatchEnd = 0;
            boolean endSlash = this.oasPath.charAt(this.oasPath.length() - 1) == '/';
            parametersMatcher.reset();
            int i = 0;
            while (parametersMatcher.find()) {
                String toQuote = this.oasPath.substring(lastMatchEnd, parametersMatcher.start());
                if (toQuote.length() != 0) {
                    regex.append(Pattern.quote(toQuote));
                }
                lastMatchEnd = parametersMatcher.end();
                String paramName = parametersMatcher.group(1);
                Optional<Parameter> parameterOptional = this.parameters.stream().filter(p -> p.getName().equals(paramName)).findFirst();
                if (parameterOptional.isPresent()) {
                    Map<String, OpenApi3Utils.ObjectField> properties;
                    Parameter parameter = parameterOptional.get();
                    String style = this.solveParamStyle(parameter);
                    boolean explode = this.solveParamExplode(parameter);
                    boolean isObject = OpenApi3Utils.isParameterObjectOrAllOfType(parameter);
                    boolean isArray = OpenApi3Utils.isParameterArrayType(parameter);
                    String groupName = "p" + i;
                    if (style.equals("simple")) {
                        regex.append(RegexBuilder.create().namedGroup(groupName, RegexBuilder.create().notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "+", "$", "/", "?", "#", "[", "]", this.shouldThreatDotAsReserved ? "." : null).zeroOrMore()).zeroOrOne());
                        this.mappedGroups.put(groupName, paramName);
                    } else if (style.equals("label")) {
                        if (isObject && explode) {
                            properties = OpenApi3Utils.solveObjectParameters(parameter.getSchema());
                            for (Map.Entry<String, OpenApi3Utils.ObjectField> entry : properties.entrySet()) {
                                groupName = "p" + i;
                                regex.append(RegexBuilder.create().optionalGroup(RegexBuilder.create().escapeCharacter(".").zeroOrOne().quote(entry.getKey()).append("=").namedGroup(groupName, RegexBuilder.create().notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "+", "$", "/", "?", "#", "[", "]", ".", "=").zeroOrMore())));
                                this.mappedGroups.put(groupName, entry.getKey());
                                ++i;
                            }
                        } else {
                            regex.append(RegexBuilder.create().escapeCharacter(".").zeroOrOne().namedGroup(groupName, RegexBuilder.create().notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "=", "+", "$", ",", "/", "?", "#", "[", "]").zeroOrMore()).zeroOrOne());
                            this.mappedGroups.put(groupName, paramName);
                        }
                    } else if (style.equals("matrix")) {
                        if (isObject && explode) {
                            properties = OpenApi3Utils.solveObjectParameters(parameter.getSchema());
                            for (Map.Entry<String, OpenApi3Utils.ObjectField> entry : properties.entrySet()) {
                                groupName = "p" + i;
                                regex.append(RegexBuilder.create().optionalGroup(RegexBuilder.create().escapeCharacter(";").quote(entry.getKey()).append("=").namedGroup(groupName, RegexBuilder.create().notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "=", "+", "$", ",", "/", "?", "#", "[", "]", this.shouldThreatDotAsReserved ? "." : null).zeroOrMore())));
                                this.mappedGroups.put(groupName, entry.getKey());
                                ++i;
                            }
                        } else if (isArray && explode) {
                            regex.append(RegexBuilder.create().namedGroup(groupName, RegexBuilder.create().atomicGroup(RegexBuilder.create().append(";").quote(paramName).append("=").notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "=", "+", "$", ",", "/", "?", "#", "[", "]", this.shouldThreatDotAsReserved ? "." : null).zeroOrMore()).oneOrMore()));
                            this.mappedGroups.put(groupName, paramName);
                        } else {
                            regex.append(RegexBuilder.create().append(";").quote(paramName).append("=").namedGroup(groupName, RegexBuilder.create().notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "=", "+", "$", "/", "?", "#", "[", "]", this.shouldThreatDotAsReserved ? "." : null).zeroOrMore()).zeroOrOne());
                            this.mappedGroups.put(groupName, paramName);
                        }
                    }
                } else {
                    throw RouterFactoryException.createSpecInvalidException("Missing parameter description for parameter name: " + paramName);
                }
                ++i;
            }
            String toAppendQuoted = this.oasPath.substring(lastMatchEnd, endSlash ? this.oasPath.length() - 1 : this.oasPath.length());
            if (toAppendQuoted.length() != 0) {
                regex.append(Pattern.quote(toAppendQuoted));
            }
            if (endSlash) {
                regex.append("\\/");
            }
            return Optional.of(Pattern.compile(regex.toString()));
        }
        return Optional.empty();
    }

    public Pattern getResolvedPattern() {
        return this.resolvedPattern;
    }

    public Map<String, String> getMappedGroups() {
        return this.mappedGroups;
    }

    private String solveParamStyle(Parameter parameter) {
        return parameter.getStyle() != null ? parameter.getStyle().toString() : "simple";
    }

    private boolean solveParamExplode(Parameter parameter) {
        return parameter.getExplode() != null ? parameter.getExplode() : false;
    }

    private boolean hasParameterWithStyle(String style) {
        return this.parameters.stream().map(this::solveParamStyle).anyMatch(s -> s.equals(style));
    }

    private boolean hasParameterWithStyleAndExplode(String style, boolean explode) {
        return this.parameters.stream().anyMatch(p -> this.solveParamStyle((Parameter)p).equals(style) && this.solveParamExplode((Parameter)p) == explode);
    }
}

