/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.Handler;
import io.vertx.ext.stomp.Destination;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.impl.Transaction;
import io.vertx.ext.stomp.impl.Transactions;
import io.vertx.ext.stomp.utils.Headers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultCommitHandler
implements Handler<ServerFrame> {
    public void handle(ServerFrame serverFrame) {
        Frame frame = serverFrame.frame();
        StompServerConnection connection = serverFrame.connection();
        String txId = frame.getHeader("transaction");
        if (txId == null) {
            Frame error = Frames.createErrorFrame("Missing transaction id", Headers.create(), "COMMIT frames must contain the 'transaction' header.");
            connection.write(error).close();
            return;
        }
        Transaction transaction = Transactions.instance().getTransaction(connection, txId);
        if (transaction == null) {
            Frame error = Frames.createErrorFrame("Unknown transaction", Headers.create("transaction", txId), "The transaction id is unknown.");
            connection.write(error).close();
            return;
        }
        this.replay(connection, transaction.getFrames());
        transaction.clear();
        Transactions.instance().unregisterTransaction(connection, txId);
        Frames.handleReceipt(frame, connection);
    }

    private void replay(StompServerConnection connection, List<Frame> frames) {
        Iterator<Frame> iterator = frames.iterator();
        while (iterator.hasNext()) {
            ArrayList<Frame> chunk = new ArrayList<Frame>();
            while (iterator.hasNext() && chunk.size() < connection.server().options().getTransactionChunkSize()) {
                chunk.add(iterator.next());
            }
            connection.server().vertx().runOnContext(v -> this.replayChunk(connection, chunk));
        }
    }

    private void replayChunk(StompServerConnection connection, List<Frame> frames) {
        List<Destination> destinations = connection.handler().getDestinations();
        block5: for (Frame frame : frames) {
            block0 : switch (frame.getCommand()) {
                case SEND: {
                    String destination = frame.getHeader("destination");
                    Destination dest = connection.handler().getDestination(destination);
                    if (dest == null) break;
                    dest.dispatch(connection, frame);
                    break;
                }
                case ACK: {
                    for (Destination d : destinations) {
                        if (!d.ack(connection, frame)) continue;
                        break block0;
                    }
                    continue block5;
                }
                case NACK: {
                    for (Destination d : destinations) {
                        if (d.nack(connection, frame)) break;
                    }
                    break;
                }
            }
        }
    }
}

