/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.stomp.Acknowledgement;
import io.vertx.ext.stomp.BridgeOptions;
import io.vertx.ext.stomp.DefaultAbortHandler;
import io.vertx.ext.stomp.DefaultAckHandler;
import io.vertx.ext.stomp.DefaultBeginHandler;
import io.vertx.ext.stomp.DefaultCommitHandler;
import io.vertx.ext.stomp.DefaultConnectHandler;
import io.vertx.ext.stomp.DefaultNackHandler;
import io.vertx.ext.stomp.DefaultSendHandler;
import io.vertx.ext.stomp.DefaultSubscribeHandler;
import io.vertx.ext.stomp.DefaultUnsubscribeHandler;
import io.vertx.ext.stomp.Destination;
import io.vertx.ext.stomp.DestinationFactory;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.StompServer;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.StompServerHandler;
import io.vertx.ext.stomp.impl.AcknowledgementImpl;
import io.vertx.ext.stomp.impl.ServerFrameImpl;
import io.vertx.ext.stomp.impl.Transactions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultStompHandler
implements StompServerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStompHandler.class);
    private final Vertx vertx;
    private final Context context;
    private Handler<ServerFrame> connectHandler;
    private Handler<ServerFrame> stompHandler;
    private Handler<ServerFrame> sendHandler = new DefaultSendHandler();
    private Handler<ServerFrame> subscribeHandler = new DefaultSubscribeHandler();
    private Handler<ServerFrame> unsubscribeHandler = new DefaultUnsubscribeHandler();
    private Handler<StompServerConnection> closeHandler;
    private Handler<ServerFrame> commitHandler = new DefaultCommitHandler();
    private Handler<ServerFrame> abortHandler = new DefaultAbortHandler();
    private Handler<ServerFrame> beginHandler = new DefaultBeginHandler();
    private Handler<ServerFrame> ackHandler = new DefaultAckHandler();
    private Handler<ServerFrame> nackHandler = new DefaultNackHandler();
    private Handler<ServerFrame> disconnectHandler = sf -> {
        StompServerConnection connection = sf.connection();
        Frames.handleReceipt(sf.frame(), connection);
        connection.close();
    };
    private AuthenticationProvider authProvider;
    private Handler<StompServerConnection> pingHandler = StompServerConnection::ping;
    private Handler<Acknowledgement> onAckHandler = acknowledgement -> LOGGER.info((Object)("Acknowledge messages - " + acknowledgement.frames()));
    private Handler<Acknowledgement> onNackHandler = acknowledgement -> LOGGER.warn((Object)("Messages not acknowledge - " + acknowledgement.frames()));
    private final LocalMap<Destination, String> destinations;
    private final ConcurrentHashMap<String, User> users;
    private DestinationFactory factory = Destination::topic;
    private Handler<ServerFrame> receivedFrameHandler;

    public DefaultStompHandler(Vertx vertx) {
        this.vertx = vertx;
        this.context = Vertx.currentContext();
        this.destinations = vertx.sharedData().getLocalMap("stomp.destinations");
        this.users = new ConcurrentHashMap();
        this.connectHandler = new DefaultConnectHandler();
    }

    @Override
    public synchronized void onClose(StompServerConnection connection) {
        this.getDestinations().stream().forEach(d -> d.unsubscribeConnection(connection));
        Transactions.instance().unregisterTransactionsFromConnection(connection);
        this.users.remove(connection.session());
        if (this.closeHandler != null) {
            this.closeHandler.handle((Object)connection);
        }
    }

    @Override
    public synchronized StompServerHandler receivedFrameHandler(Handler<ServerFrame> handler) {
        this.receivedFrameHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler connectHandler(Handler<ServerFrame> handler) {
        this.connectHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler stompHandler(Handler<ServerFrame> handler) {
        this.stompHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler subscribeHandler(Handler<ServerFrame> handler) {
        this.subscribeHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler unsubscribeHandler(Handler<ServerFrame> handler) {
        this.unsubscribeHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler sendHandler(Handler<ServerFrame> handler) {
        this.sendHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler closeHandler(Handler<StompServerConnection> handler) {
        this.closeHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler commitHandler(Handler<ServerFrame> handler) {
        this.commitHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler abortHandler(Handler<ServerFrame> handler) {
        this.abortHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler beginHandler(Handler<ServerFrame> handler) {
        this.beginHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler disconnectHandler(Handler<ServerFrame> handler) {
        this.disconnectHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler ackHandler(Handler<ServerFrame> handler) {
        this.ackHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler nackHandler(Handler<ServerFrame> handler) {
        this.nackHandler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ServerFrame serverFrame) {
        Frame frame = serverFrame.frame();
        StompServerConnection connection = serverFrame.connection();
        connection.onServerActivity();
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            if (this.receivedFrameHandler != null) {
                this.receivedFrameHandler.handle((Object)serverFrame);
            }
        }
        switch (frame.getCommand()) {
            case CONNECT: {
                this.handleConnect(frame, connection);
                break;
            }
            case STOMP: {
                this.handleStomp(frame, connection);
                break;
            }
            case SEND: {
                this.handleSend(frame, connection);
                break;
            }
            case SUBSCRIBE: {
                this.handleSubscribe(frame, connection);
                break;
            }
            case UNSUBSCRIBE: {
                this.handleUnsubscribe(frame, connection);
                break;
            }
            case BEGIN: {
                this.handleBegin(frame, connection);
                break;
            }
            case ABORT: {
                this.handleAbort(frame, connection);
                break;
            }
            case COMMIT: {
                this.handleCommit(frame, connection);
                break;
            }
            case ACK: {
                this.handleAck(frame, connection);
                break;
            }
            case NACK: {
                this.handleNack(frame, connection);
                break;
            }
            case DISCONNECT: {
                this.handleDisconnect(frame, connection);
                break;
            }
            case PING: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAck(Frame frame, StompServerConnection connection) {
        Handler<ServerFrame> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.ackHandler;
        }
        if (handler != null) {
            handler.handle((Object)new ServerFrameImpl(frame, connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNack(Frame frame, StompServerConnection connection) {
        Handler<ServerFrame> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.nackHandler;
        }
        if (handler != null) {
            handler.handle((Object)new ServerFrameImpl(frame, connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBegin(Frame frame, StompServerConnection connection) {
        Handler<ServerFrame> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.beginHandler;
        }
        if (handler != null) {
            handler.handle((Object)new ServerFrameImpl(frame, connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAbort(Frame frame, StompServerConnection connection) {
        Handler<ServerFrame> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.abortHandler;
        }
        if (handler != null) {
            handler.handle((Object)new ServerFrameImpl(frame, connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCommit(Frame frame, StompServerConnection connection) {
        Handler<ServerFrame> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.commitHandler;
        }
        if (handler != null) {
            handler.handle((Object)new ServerFrameImpl(frame, connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubscribe(Frame frame, StompServerConnection connection) {
        Handler<ServerFrame> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.subscribeHandler;
        }
        if (handler != null) {
            handler.handle((Object)new ServerFrameImpl(frame, connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnsubscribe(Frame frame, StompServerConnection connection) {
        Handler<ServerFrame> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.unsubscribeHandler;
        }
        if (handler != null) {
            handler.handle((Object)new ServerFrameImpl(frame, connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSend(Frame frame, StompServerConnection connection) {
        Handler<ServerFrame> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.sendHandler;
        }
        if (handler != null) {
            handler.handle((Object)new ServerFrameImpl(frame, connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnect(Frame frame, StompServerConnection connection) {
        Handler<StompServerConnection> pingH;
        Handler<ServerFrame> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.connectHandler;
            pingH = this.pingHandler;
        }
        long ping = Frame.Heartbeat.computePingPeriod(Frame.Heartbeat.create(connection.server().options().getHeartbeat()), Frame.Heartbeat.parse(frame.getHeader("heart-beat")));
        long pong = Frame.Heartbeat.computePongPeriod(Frame.Heartbeat.create(connection.server().options().getHeartbeat()), Frame.Heartbeat.parse(frame.getHeader("heart-beat")));
        connection.configureHeartbeat(ping, pong, pingH);
        if (handler != null) {
            handler.handle((Object)new ServerFrameImpl(frame, connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisconnect(Frame frame, StompServerConnection connection) {
        Handler<ServerFrame> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.disconnectHandler;
        }
        if (handler != null) {
            handler.handle((Object)new ServerFrameImpl(frame, connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStomp(Frame frame, StompServerConnection connection) {
        Handler<ServerFrame> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.stompHandler;
        }
        if (handler == null) {
            this.handleConnect(frame, connection);
            return;
        }
        handler.handle((Object)new ServerFrameImpl(frame, connection));
    }

    @Override
    public synchronized StompServerHandler authProvider(AuthenticationProvider handler) {
        this.authProvider = handler;
        return this;
    }

    @Override
    public Future<Boolean> onAuthenticationRequest(StompServerConnection connection, String login, String passcode) {
        PromiseInternal promise = ((ContextInternal)this.context).promise();
        this.onAuthenticationRequest(connection, login, passcode, (Completable<Boolean>)promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StompServerHandler onAuthenticationRequest(StompServerConnection connection, String login, String passcode, Completable<Boolean> handler) {
        AuthenticationProvider auth;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            auth = this.authProvider;
        }
        StompServer server = connection.server();
        if (!server.options().isSecured()) {
            if (auth != null) {
                LOGGER.warn((Object)"Authentication handler set while the server is not secured");
            }
            this.context.runOnContext(v -> handler.succeed((Object)true));
            return this;
        }
        if (server.options().isSecured() && auth == null) {
            LOGGER.error((Object)"Cannot authenticate connection - no authentication provider");
            this.context.runOnContext(v -> handler.succeed((Object)false));
            return this;
        }
        this.context.runOnContext(v -> auth.authenticate((Credentials)new UsernamePasswordCredentials(login, passcode)).onFailure(err -> this.context.runOnContext(v2 -> handler.succeed((Object)false))).onSuccess(user -> {
            this.users.put(connection.session(), (User)user);
            this.context.runOnContext(v2 -> handler.succeed((Object)true));
        }));
        return this;
    }

    @Override
    public User getUserBySession(String session) {
        return this.users.get(session);
    }

    @Override
    public List<Destination> getDestinations() {
        return new ArrayList<Destination>(this.destinations.keySet());
    }

    @Override
    public Destination getDestination(String destination) {
        for (Destination d : this.destinations.keySet()) {
            if (!d.matches(destination)) continue;
            return d;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination getOrCreateDestination(String destination) {
        DestinationFactory destinationFactory;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            destinationFactory = this.factory;
        }
        defaultStompHandler = this.vertx;
        synchronized (defaultStompHandler) {
            Destination d = this.getDestination(destination);
            if (d == null && (d = destinationFactory.create(this.vertx, destination)) != null) {
                this.destinations.put((Object)d, (Object)"");
            }
            return d;
        }
    }

    @Override
    public synchronized StompServerHandler destinationFactory(DestinationFactory factory) {
        this.factory = factory;
        return this;
    }

    @Override
    public synchronized StompServerHandler bridge(BridgeOptions options) {
        this.destinations.put((Object)Destination.bridge(this.vertx, options), (Object)"");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StompServerHandler onAck(StompServerConnection connection, Frame subscription, List<Frame> messages) {
        Handler<Acknowledgement> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.onAckHandler;
        }
        if (handler != null) {
            handler.handle((Object)new AcknowledgementImpl(subscription, messages));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StompServerHandler onNack(StompServerConnection connection, Frame subscribe, List<Frame> messages) {
        Handler<Acknowledgement> handler;
        DefaultStompHandler defaultStompHandler = this;
        synchronized (defaultStompHandler) {
            handler = this.onNackHandler;
        }
        if (handler != null) {
            handler.handle((Object)new AcknowledgementImpl(subscribe, messages));
        }
        return this;
    }

    @Override
    public synchronized StompServerHandler onAckHandler(Handler<Acknowledgement> handler) {
        this.onAckHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler onNackHandler(Handler<Acknowledgement> handler) {
        this.onNackHandler = handler;
        return this;
    }

    @Override
    public synchronized StompServerHandler pingHandler(Handler<StompServerConnection> handler) {
        this.pingHandler = handler;
        return this;
    }
}

