/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.StompServerConnection;
import java.util.ArrayList;
import java.util.List;

public class Transaction {
    private final List<Frame> frames;
    private final String id;
    private final StompServerConnection connection;

    public Transaction(StompServerConnection connection, String id) {
        this.connection = connection;
        this.id = id;
        this.frames = new ArrayList<Frame>();
    }

    public StompServerConnection connection() {
        return this.connection;
    }

    public String id() {
        return this.id;
    }

    public synchronized boolean addFrameToTransaction(Frame frame) {
        return this.frames.size() < this.connection.server().options().getMaxFrameInTransaction() && this.frames.add(frame);
    }

    public synchronized Transaction clear() {
        this.frames.clear();
        return this;
    }

    public synchronized List<Frame> getFrames() {
        return new ArrayList<Frame>(this.frames);
    }
}

