/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.stomp;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.stomp.BridgeOptions;
import io.vertx.ext.stomp.Frame;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.ext.auth.AuthProvider;
import io.vertx.rxjava.ext.stomp.Acknowledgement;
import io.vertx.rxjava.ext.stomp.Destination;
import io.vertx.rxjava.ext.stomp.DestinationFactory;
import io.vertx.rxjava.ext.stomp.ServerFrame;
import io.vertx.rxjava.ext.stomp.StompServerConnection;
import java.util.List;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.stomp.StompServerHandler.class)
public class StompServerHandler
implements Handler<ServerFrame> {
    public static final TypeArg<StompServerHandler> __TYPE_ARG = new TypeArg(obj -> new StompServerHandler((io.vertx.ext.stomp.StompServerHandler)obj), StompServerHandler::getDelegate);
    private final io.vertx.ext.stomp.StompServerHandler delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StompServerHandler that = (StompServerHandler)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public StompServerHandler(io.vertx.ext.stomp.StompServerHandler delegate) {
        this.delegate = delegate;
    }

    public io.vertx.ext.stomp.StompServerHandler getDelegate() {
        return this.delegate;
    }

    public void handle(ServerFrame arg0) {
        this.delegate.handle(arg0.getDelegate());
    }

    public static StompServerHandler create(Vertx vertx) {
        StompServerHandler ret = StompServerHandler.newInstance(io.vertx.ext.stomp.StompServerHandler.create(vertx.getDelegate()));
        return ret;
    }

    public StompServerHandler receivedFrameHandler(final Handler<ServerFrame> handler) {
        this.delegate.receivedFrameHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler connectHandler(final Handler<ServerFrame> handler) {
        this.delegate.connectHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler stompHandler(final Handler<ServerFrame> handler) {
        this.delegate.stompHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler subscribeHandler(final Handler<ServerFrame> handler) {
        this.delegate.subscribeHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler unsubscribeHandler(final Handler<ServerFrame> handler) {
        this.delegate.unsubscribeHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler sendHandler(final Handler<ServerFrame> handler) {
        this.delegate.sendHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler closeHandler(final Handler<StompServerConnection> handler) {
        this.delegate.closeHandler(new Handler<io.vertx.ext.stomp.StompServerConnection>(){

            public void handle(io.vertx.ext.stomp.StompServerConnection event) {
                handler.handle((Object)StompServerConnection.newInstance(event));
            }
        });
        return this;
    }

    public void onClose(StompServerConnection connection) {
        this.delegate.onClose(connection.getDelegate());
    }

    public StompServerHandler commitHandler(final Handler<ServerFrame> handler) {
        this.delegate.commitHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler abortHandler(final Handler<ServerFrame> handler) {
        this.delegate.abortHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler beginHandler(final Handler<ServerFrame> handler) {
        this.delegate.beginHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler disconnectHandler(final Handler<ServerFrame> handler) {
        this.delegate.disconnectHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler ackHandler(final Handler<ServerFrame> handler) {
        this.delegate.ackHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler nackHandler(final Handler<ServerFrame> handler) {
        this.delegate.nackHandler(new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler onAuthenticationRequest(StompServerConnection connection, String login, String passcode, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.onAuthenticationRequest(connection.getDelegate(), login, passcode, handler);
        return this;
    }

    @Deprecated
    public Observable<Boolean> onAuthenticationRequestObservable(StompServerConnection connection, String login, String passcode) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.onAuthenticationRequest(connection, login, passcode, (Handler<AsyncResult<Boolean>>)handler.toHandler());
        return handler;
    }

    public Single<Boolean> rxOnAuthenticationRequest(StompServerConnection connection, String login, String passcode) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.onAuthenticationRequest(connection, login, passcode, (Handler<AsyncResult<Boolean>>)fut)));
    }

    public io.vertx.rxjava.ext.auth.User getUserBySession(String session) {
        io.vertx.rxjava.ext.auth.User ret = io.vertx.rxjava.ext.auth.User.newInstance((User)this.delegate.getUserBySession(session));
        return ret;
    }

    public StompServerHandler authProvider(AuthProvider handler) {
        this.delegate.authProvider(handler.getDelegate());
        return this;
    }

    public List<Destination> getDestinations() {
        List<Destination> ret = this.delegate.getDestinations().stream().map(elt -> Destination.newInstance(elt)).collect(Collectors.toList());
        return ret;
    }

    public Destination getDestination(String destination) {
        Destination ret = Destination.newInstance(this.delegate.getDestination(destination));
        return ret;
    }

    public StompServerHandler onAck(StompServerConnection connection, Frame subscribe, List<Frame> messages) {
        this.delegate.onAck(connection.getDelegate(), subscribe, messages);
        return this;
    }

    public StompServerHandler onNack(StompServerConnection connection, Frame subscribe, List<Frame> messages) {
        this.delegate.onNack(connection.getDelegate(), subscribe, messages);
        return this;
    }

    public StompServerHandler onAckHandler(final Handler<Acknowledgement> handler) {
        this.delegate.onAckHandler(new Handler<io.vertx.ext.stomp.Acknowledgement>(){

            public void handle(io.vertx.ext.stomp.Acknowledgement event) {
                handler.handle((Object)Acknowledgement.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler onNackHandler(final Handler<Acknowledgement> handler) {
        this.delegate.onNackHandler(new Handler<io.vertx.ext.stomp.Acknowledgement>(){

            public void handle(io.vertx.ext.stomp.Acknowledgement event) {
                handler.handle((Object)Acknowledgement.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler pingHandler(final Handler<StompServerConnection> handler) {
        this.delegate.pingHandler(new Handler<io.vertx.ext.stomp.StompServerConnection>(){

            public void handle(io.vertx.ext.stomp.StompServerConnection event) {
                handler.handle((Object)StompServerConnection.newInstance(event));
            }
        });
        return this;
    }

    public Destination getOrCreateDestination(String destination) {
        Destination ret = Destination.newInstance(this.delegate.getOrCreateDestination(destination));
        return ret;
    }

    public StompServerHandler destinationFactory(DestinationFactory factory) {
        this.delegate.destinationFactory(factory.getDelegate());
        return this;
    }

    public StompServerHandler bridge(BridgeOptions options) {
        this.delegate.bridge(options);
        return this;
    }

    public static StompServerHandler newInstance(io.vertx.ext.stomp.StompServerHandler arg) {
        return arg != null ? new StompServerHandler(arg) : null;
    }
}

