/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.stomp.StompServerOptions;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class StompServerOptionsConverter {
    public static void fromJson(JsonObject json, StompServerOptions obj) {
        if (json.getValue("heartbeat") instanceof JsonObject) {
            obj.setHeartbeat(((JsonObject)json.getValue("heartbeat")).copy());
        }
        if (json.getValue("maxBodyLength") instanceof Number) {
            obj.setMaxBodyLength(((Number)json.getValue("maxBodyLength")).intValue());
        }
        if (json.getValue("maxFrameInTransaction") instanceof Number) {
            obj.setMaxFrameInTransaction(((Number)json.getValue("maxFrameInTransaction")).intValue());
        }
        if (json.getValue("maxHeaderLength") instanceof Number) {
            obj.setMaxHeaderLength(((Number)json.getValue("maxHeaderLength")).intValue());
        }
        if (json.getValue("maxHeaders") instanceof Number) {
            obj.setMaxHeaders(((Number)json.getValue("maxHeaders")).intValue());
        }
        if (json.getValue("maxSubscriptionsByClient") instanceof Number) {
            obj.setMaxSubscriptionsByClient(((Number)json.getValue("maxSubscriptionsByClient")).intValue());
        }
        if (json.getValue("secured") instanceof Boolean) {
            obj.setSecured((Boolean)json.getValue("secured"));
        }
        if (json.getValue("sendErrorOnNoSubscriptions") instanceof Boolean) {
            obj.setSendErrorOnNoSubscriptions((Boolean)json.getValue("sendErrorOnNoSubscriptions"));
        }
        if (json.getValue("supportedVersions") instanceof JsonArray) {
            ArrayList<String> list = new ArrayList<String>();
            json.getJsonArray("supportedVersions").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setSupportedVersions(list);
        }
        if (json.getValue("timeFactor") instanceof Number) {
            obj.setTimeFactor(((Number)json.getValue("timeFactor")).intValue());
        }
        if (json.getValue("trailingLine") instanceof Boolean) {
            obj.setTrailingLine((Boolean)json.getValue("trailingLine"));
        }
        if (json.getValue("transactionChunkSize") instanceof Number) {
            obj.setTransactionChunkSize(((Number)json.getValue("transactionChunkSize")).intValue());
        }
        if (json.getValue("websocketBridge") instanceof Boolean) {
            obj.setWebsocketBridge((Boolean)json.getValue("websocketBridge"));
        }
        if (json.getValue("websocketPath") instanceof String) {
            obj.setWebsocketPath((String)json.getValue("websocketPath"));
        }
    }

    public static void toJson(StompServerOptions obj, JsonObject json) {
        if (obj.getHeartbeat() != null) {
            json.put("heartbeat", obj.getHeartbeat());
        }
        json.put("maxBodyLength", Integer.valueOf(obj.getMaxBodyLength()));
        json.put("maxFrameInTransaction", Integer.valueOf(obj.getMaxFrameInTransaction()));
        json.put("maxHeaderLength", Integer.valueOf(obj.getMaxHeaderLength()));
        json.put("maxHeaders", Integer.valueOf(obj.getMaxHeaders()));
        json.put("maxSubscriptionsByClient", Integer.valueOf(obj.getMaxSubscriptionsByClient()));
        json.put("secured", Boolean.valueOf(obj.isSecured()));
        json.put("sendErrorOnNoSubscriptions", Boolean.valueOf(obj.isSendErrorOnNoSubscriptions()));
        if (obj.getSupportedVersions() != null) {
            json.put("supportedVersions", new JsonArray(obj.getSupportedVersions().stream().map(item -> item).collect(Collectors.toList())));
        }
        json.put("timeFactor", Integer.valueOf(obj.getTimeFactor()));
        json.put("trailingLine", Boolean.valueOf(obj.isTrailingLine()));
        json.put("transactionChunkSize", Integer.valueOf(obj.getTransactionChunkSize()));
        json.put("websocketBridge", Boolean.valueOf(obj.isWebsocketBridge()));
        if (obj.getWebsocketPath() != null) {
            json.put("websocketPath", obj.getWebsocketPath());
        }
    }
}

