/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.StompServer;
import io.vertx.ext.stomp.StompServerHandler;
import io.vertx.ext.stomp.StompServerOptions;
import io.vertx.ext.stomp.impl.FrameException;
import io.vertx.ext.stomp.impl.FrameParser;
import io.vertx.ext.stomp.impl.ServerFrameImpl;
import io.vertx.ext.stomp.impl.StompServerConnectionImpl;
import java.util.Objects;

public class StompServerImpl
implements StompServer {
    private static final Logger log = LoggerFactory.getLogger(StompServerImpl.class);
    private final Vertx vertx;
    private final StompServerOptions options;
    private final NetServer server;
    private StompServerHandler handler;
    private volatile boolean listening;

    public StompServerImpl(Vertx vertx, NetServer net, StompServerOptions options) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(options);
        this.options = options;
        this.vertx = vertx;
        this.server = net == null ? vertx.createNetServer((NetServerOptions)options) : net;
    }

    @Override
    public synchronized StompServer handler(StompServerHandler handler) {
        Objects.requireNonNull(handler);
        this.handler = handler;
        return this;
    }

    @Override
    public StompServer listen() {
        return this.listen(null);
    }

    @Override
    public StompServer listen(Handler<AsyncResult<StompServer>> handler) {
        return this.listen(this.options.getPort(), this.options.getHost(), handler);
    }

    @Override
    public StompServer listen(int port) {
        return this.listen(port, "0.0.0.0");
    }

    @Override
    public StompServer listen(int port, String host) {
        return this.listen(port, host, null);
    }

    @Override
    public StompServer listen(int port, Handler<AsyncResult<StompServer>> handler) {
        return this.listen(port, "0.0.0.0", handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StompServer listen(int port, String host, Handler<AsyncResult<StompServer>> handler) {
        StompServerHandler stomp;
        StompServerImpl stompServerImpl = this;
        synchronized (stompServerImpl) {
            stomp = this.handler;
        }
        Objects.requireNonNull(stomp, "Cannot open STOMP server - no StompServerConnectionHandler attached to the server.");
        this.server.connectHandler(socket -> {
            StompServerConnectionImpl connection = new StompServerConnectionImpl((NetSocket)socket, this);
            FrameParser parser = new FrameParser(this.options);
            socket.exceptionHandler(exception -> {
                log.error((Object)"The STOMP server caught a TCP socket error - closing connection", exception);
                connection.close();
            });
            socket.endHandler(v -> connection.close());
            parser.errorHandler((Handler<FrameException>)((Handler)exception -> {
                connection.write(Frames.createInvalidFrameErrorFrame(exception).toBuffer());
                connection.close();
            })).handler((Handler<Frame>)((Handler)frame -> stomp.handle(new ServerFrameImpl((Frame)frame, connection))));
            socket.handler(parser::handle);
        }).listen(port, host, ar -> {
            if (ar.failed()) {
                if (handler != null) {
                    this.vertx.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)ar.cause())));
                } else {
                    log.error((Object)ar.cause());
                }
            } else {
                this.listening = true;
                log.info((Object)("STOMP server listening on " + ((NetServer)ar.result()).actualPort()));
                if (handler != null) {
                    this.vertx.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)this)));
                }
            }
        });
        return this;
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    @Override
    public int actualPort() {
        return this.server.actualPort();
    }

    @Override
    public StompServerOptions options() {
        return this.options;
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public synchronized StompServerHandler stompHandler() {
        return this.handler;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> done) {
        if (!this.listening) {
            if (done != null) {
                this.vertx.runOnContext(v -> done.handle((Object)Future.succeededFuture()));
            }
            return;
        }
        Handler listener = v -> {
            if (v.succeeded()) {
                log.info((Object)"STOMP Server stopped");
            } else {
                log.info((Object)"STOMP Server failed to stop", v.cause());
            }
            this.listening = false;
            if (done != null) {
                done.handle(v);
            }
        };
        this.server.close(listener);
    }
}

