/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.stomp.FrameConverter;
import io.vertx.ext.stomp.impl.FrameException;
import io.vertx.ext.stomp.impl.HeaderCodec;
import io.vertx.ext.stomp.utils.Headers;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DataObject(generateConverter=true)
public class Frame {
    public static final String CONTENT_LENGTH = "content-length";
    public static final String CONTENT_TYPE = "content-type";
    public static final String HOST = "host";
    public static final String VERSION = "version";
    public static final String ACCEPT_VERSION = "accept-version";
    public static final String SESSION = "session";
    public static final String SERVER = "server";
    public static final String LOGIN = "login";
    public static final String PASSCODE = "passcode";
    public static final String HEARTBEAT = "heart-beat";
    public static final String DESTINATION = "destination";
    public static final String RECEIPT = "receipt";
    public static final String RECEIPT_ID = "receipt-id";
    public static final String ACK = "ack";
    public static final String ID = "id";
    public static final String SUBSCRIPTION = "subscription";
    public static final String MESSAGE_ID = "message-id";
    public static final String TRANSACTION = "transaction";
    public static final String MESSAGE = "message";
    private static final Pattern CHARSET_PATTERN = Pattern.compile(".+;charset=([a-zA-Z0-9\\-]+);?.*");
    private static final List<Command> COMMANDS_ACCEPTING_BODY = Arrays.asList(Command.SEND, Command.MESSAGE, Command.ERROR);
    private Command command;
    private final Map<String, String> headers;
    private Buffer body;

    public Frame() {
        this.headers = new Headers();
    }

    public Frame(Frame other) {
        this();
        this.command = other.command;
        this.headers.putAll(this.headers);
        if (other.body != null) {
            this.body = other.body.copy();
        }
        this.validate();
    }

    public Frame(JsonObject json) {
        this();
        FrameConverter.fromJson(json, this);
        this.validate();
    }

    public Frame(Command command, Map<String, String> headers, Buffer body) {
        Objects.requireNonNull(command, "The frame command must be set");
        Objects.requireNonNull(headers, "The headers must be set to empty if none");
        this.command = command;
        this.headers = headers;
        this.body = body;
        this.validate();
    }

    public Frame addHeader(String key, String value) {
        this.headers.putIfAbsent(key, value);
        return this;
    }

    public String getAck() {
        return this.headers.get(ACK);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Frame setHeaders(Map<String, String> headers) {
        if (headers == null) {
            this.headers.clear();
        } else {
            this.headers.clear();
            this.headers.putAll(headers);
        }
        return this;
    }

    public Frame setCommand(Command command) {
        Objects.requireNonNull(command, "The frame command must not be null.");
        this.command = command;
        return this;
    }

    public Frame setBody(Buffer body) {
        this.body = body;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        FrameConverter.toJson(this, json);
        return json;
    }

    public void validate() {
        if (this.command == null) {
            throw new FrameException("The frame does not have a command");
        }
        if (!COMMANDS_ACCEPTING_BODY.contains((Object)this.command) && !this.hasEmptyBody()) {
            throw new FrameException("The frame " + this.command.name() + " cannot have a body");
        }
    }

    public boolean hasEmptyBody() {
        return this.body == null || this.body.length() == 0;
    }

    public Command getCommand() {
        return this.command;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Buffer getBody() {
        return this.body;
    }

    public String getBodyAsString(String encoding) {
        if (this.body == null) {
            return null;
        }
        return this.body.toString(encoding);
    }

    public String getBodyAsString() {
        return this.getBodyAsString(this.encoding());
    }

    public String encoding() {
        String header = this.getHeader(CONTENT_TYPE);
        if (header == null) {
            return "utf-8";
        }
        Matcher matcher = CHARSET_PATTERN.matcher(header);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "utf-8";
    }

    @GenIgnore
    public byte[] getBodyAsByteArray() {
        if (this.body == null) {
            return null;
        }
        return this.body.getBytes();
    }

    public Buffer toBuffer() {
        Buffer buffer = Buffer.buffer((String)(this.command.name() + "\n"));
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            buffer.appendString(this.encode(entry.getKey()) + ":" + this.encode(entry.getValue()) + "\n");
        }
        buffer.appendString("\n");
        if (this.body != null) {
            buffer.appendBuffer(this.body);
        }
        buffer.appendString("\u0000");
        return buffer;
    }

    private String encode(String header) {
        return HeaderCodec.encode(header, this.command == Command.CONNECT || this.command == Command.CONNECTED);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.command.name() + "\n");
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (entry.getKey().equals(PASSCODE)) {
                buffer.append(entry.getKey()).append(":").append("********").append("\n");
                continue;
            }
            buffer.append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
        }
        buffer.append("\n");
        if (this.body != null) {
            buffer.append(this.body);
        }
        buffer.append("^@");
        return buffer.toString();
    }

    public Frame setDestination(String destination) {
        Objects.requireNonNull(destination);
        return this.addHeader(DESTINATION, destination);
    }

    public Frame setTransaction(String id) {
        Objects.requireNonNull(id);
        return this.addHeader(TRANSACTION, id);
    }

    public Frame setId(String id) {
        Objects.requireNonNull(id);
        return this.addHeader(ID, id);
    }

    public String getId() {
        return this.getHeader(ID);
    }

    public String getReceipt() {
        return this.getHeader(RECEIPT);
    }

    public String getTransaction() {
        return this.getHeader(TRANSACTION);
    }

    public String getDestination() {
        return this.getHeader(DESTINATION);
    }

    public static class Heartbeat {
        final int x;
        final int y;

        public Heartbeat(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public static Heartbeat parse(String header) {
            if (header == null) {
                return new Heartbeat(0, 0);
            }
            String[] token = header.split(",");
            return new Heartbeat(Integer.parseInt(token[0]), Integer.parseInt(token[1]));
        }

        public static Heartbeat create(JsonObject json) {
            return new Heartbeat(json.getInteger("x", Integer.valueOf(0)), json.getInteger("y", Integer.valueOf(0)));
        }

        public String toString() {
            return this.x + "," + this.y;
        }

        public static long computePingPeriod(Heartbeat client, Heartbeat server) {
            if (client.x == 0 || server.y == 0) {
                return 0L;
            }
            return Math.max(client.x, server.y);
        }

        public static long computePongPeriod(Heartbeat client, Heartbeat server) {
            if (client.y == 0 || server.x == 0) {
                return 0L;
            }
            return Math.max(client.y, server.x);
        }
    }

    public static enum Command {
        CONNECT,
        CONNECTED,
        STOMP,
        SEND,
        SUBSCRIBE,
        UNSUBSCRIBE,
        ACK,
        NACK,
        BEGIN,
        COMMIT,
        ABORT,
        DISCONNECT,
        MESSAGE,
        RECEIPT,
        ERROR,
        PING;

    }
}

