/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.core.Vertx;
import io.vertx.ext.stomp.Destination;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.utils.Headers;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class Queue
implements Destination {
    private final String destination;
    private final List<Subscription> subscriptions = new ArrayList<Subscription>();
    private final Vertx vertx;
    private int lastUsedSubscriptions = -1;

    public Queue(Vertx vertx, String destination) {
        this.destination = destination;
        this.vertx = vertx;
    }

    @Override
    public String destination() {
        return this.destination;
    }

    @Override
    public synchronized Destination dispatch(StompServerConnection connection, Frame frame) {
        if (this.subscriptions.isEmpty()) {
            this.lastUsedSubscriptions = -1;
            return this;
        }
        Subscription subscription = this.getNextSubscription();
        String messageId = UUID.randomUUID().toString();
        Frame message = Queue.transform(frame, subscription, messageId);
        subscription.connection.write(message.toBuffer());
        return this;
    }

    private Subscription getNextSubscription() {
        ++this.lastUsedSubscriptions;
        if (this.lastUsedSubscriptions >= this.subscriptions.size()) {
            this.lastUsedSubscriptions = 0;
        }
        return this.subscriptions.get(this.lastUsedSubscriptions);
    }

    public static Frame transform(Frame frame, Subscription subscription, String messageId) {
        Headers headers = Headers.create(frame.getHeaders()).add("subscription", subscription.id).add("message-id", messageId);
        if (!subscription.ackMode.equals("auto")) {
            headers.add("ack", messageId);
        }
        return new Frame(Frame.Command.MESSAGE, headers, frame.getBody());
    }

    @Override
    public synchronized Destination subscribe(StompServerConnection connection, Frame frame) {
        Subscription subscription = new Subscription(connection, frame);
        this.subscriptions.add(subscription);
        return this;
    }

    @Override
    public synchronized boolean unsubscribe(StompServerConnection connection, Frame frame) {
        boolean r = false;
        for (Subscription subscription : this.subscriptions) {
            if (!subscription.connection.equals(connection) || !subscription.id.equals(frame.getId())) continue;
            r = this.subscriptions.remove(subscription);
            break;
        }
        if (this.subscriptions.isEmpty()) {
            this.vertx.sharedData().getLocalMap("stomp.destinations").remove((Object)this);
        }
        return r;
    }

    @Override
    public synchronized Destination unsubscribeConnection(StompServerConnection connection) {
        new ArrayList<Subscription>(this.subscriptions).stream().filter(subscription -> ((Subscription)subscription).connection.equals(connection)).forEach(this.subscriptions::remove);
        if (this.subscriptions.isEmpty()) {
            this.vertx.sharedData().getLocalMap("stomp.destinations").remove((Object)this);
        }
        return this;
    }

    @Override
    public synchronized boolean ack(StompServerConnection connection, Frame frame) {
        return false;
    }

    @Override
    public synchronized boolean nack(StompServerConnection connection, Frame frame) {
        return false;
    }

    @Override
    public synchronized List<String> getSubscriptions(StompServerConnection connection) {
        return this.subscriptions.stream().filter(subscription -> ((Subscription)subscription).connection.equals(connection)).map(s -> ((Subscription)s).id).collect(Collectors.toList());
    }

    @Override
    public synchronized int numberOfSubscriptions() {
        return this.subscriptions.size();
    }

    @Override
    public boolean matches(String address) {
        return this.destination.equals(address);
    }

    private class Subscription {
        private final StompServerConnection connection;
        private final String id;
        private final String ackMode;

        private Subscription(StompServerConnection connection, Frame frame) {
            this.connection = connection;
            this.ackMode = frame.getAck();
            this.id = frame.getId();
        }
    }
}

