/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.internal.pool;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.TransactionPropagation;
import io.vertx.sqlclient.impl.SqlClientInternal;
import io.vertx.sqlclient.spi.Driver;
import java.util.function.Function;

public class CloseablePool
implements Pool,
SqlClientInternal {
    private final VertxInternal vertx;
    private final CloseFuture closeFuture;
    private final Pool delegate;

    public CloseablePool(VertxInternal vertx, CloseFuture closeFuture, Pool delegate) {
        this.vertx = vertx;
        this.closeFuture = closeFuture;
        this.delegate = delegate;
    }

    @Override
    public Driver driver() {
        return ((SqlClientInternal)((Object)this.delegate)).driver();
    }

    @Override
    public void group(Handler<SqlClient> block) {
    }

    @Override
    public Future<SqlConnection> getConnection() {
        return this.delegate.getConnection();
    }

    @Override
    public Query<RowSet<Row>> query(String sql) {
        return this.delegate.query(sql);
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        return this.delegate.preparedQuery(sql);
    }

    @Override
    public <T> Future<@Nullable T> withTransaction(TransactionPropagation txPropagation, Function<SqlConnection, Future<@Nullable T>> function) {
        return this.delegate.withTransaction(txPropagation, function);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql, PrepareOptions options) {
        return this.delegate.preparedQuery(sql, options);
    }

    @Override
    public Future<Void> close() {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        PromiseInternal promise = closingCtx.promise();
        this.closeFuture.close((Completable)promise);
        return promise.future();
    }
}

