/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.tracing;

import io.vertx.core.Context;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.QueryResultBuilder;
import io.vertx.sqlclient.impl.tracing.QueryRequest;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.command.ExtendedQueryCommand;
import io.vertx.sqlclient.internal.command.QueryCommandBase;
import io.vertx.sqlclient.internal.command.SimpleQueryCommand;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class QueryReporter {
    private static final TagExtractor<QueryRequest> REQUEST_TAG_EXTRACTOR = new TagExtractor<QueryRequest>(){
        private final RequestTags[] TAGS = RequestTags.values();

        public int len(QueryRequest obj) {
            return this.TAGS.length;
        }

        public String name(QueryRequest obj, int index) {
            return this.TAGS[index].name;
        }

        public String value(QueryRequest obj, int index) {
            return this.TAGS[index].fn.apply(obj);
        }
    };
    private final QueryCommandBase<?> cmd;
    private final VertxTracer tracer;
    private final ClientMetrics metrics;
    private final ContextInternal context;
    private final TracingPolicy tracingPolicy;
    private final String address;
    private final String user;
    private final String system;
    private final String database;
    private Object payload;
    private Object metric;

    public QueryReporter(VertxTracer tracer, ClientMetrics metrics, ContextInternal context, QueryCommandBase<?> queryCmd, Connection conn) {
        this.tracer = tracer;
        this.metrics = metrics;
        this.context = context;
        this.tracingPolicy = conn.tracingPolicy();
        this.address = conn.server().hostAddress() + ":" + conn.server().port();
        this.user = conn.user();
        this.system = conn.system();
        this.database = conn.database();
        this.cmd = queryCmd;
    }

    private Object sendRequest(ContextInternal context, String sql) {
        QueryRequest request = new QueryRequest(this, sql, Collections.emptyList());
        return this.tracer.sendRequest((Context)context, SpanKind.RPC, this.tracingPolicy, (Object)request, "Query", (k, v) -> {}, REQUEST_TAG_EXTRACTOR);
    }

    private Object sendRequest(ContextInternal context, String sql, Tuple tuple) {
        QueryRequest request = new QueryRequest(this, sql, Collections.singletonList(tuple));
        return this.tracer.sendRequest((Context)context, SpanKind.RPC, this.tracingPolicy, (Object)request, "Query", (k, v) -> {}, REQUEST_TAG_EXTRACTOR);
    }

    private Object sendRequest(ContextInternal context, String sql, List<Tuple> tuples) {
        QueryRequest request = new QueryRequest(this, sql, tuples);
        return this.tracer.sendRequest((Context)context, SpanKind.RPC, this.tracingPolicy, (Object)request, "Query", (k, v) -> {}, REQUEST_TAG_EXTRACTOR);
    }

    private void receiveResponse(ContextInternal context, Object payload, Object result, Throwable failure) {
        this.tracer.receiveResponse((Context)context, result, payload, failure, TagExtractor.empty());
    }

    public void before() {
        String sql;
        if (this.tracer != null) {
            ExtendedQueryCommand extendedQueryCmd;
            sql = this.cmd.sql();
            this.payload = this.cmd instanceof SimpleQueryCommand ? this.sendRequest(this.context, sql) : ((extendedQueryCmd = (ExtendedQueryCommand)this.cmd).params() != null ? this.sendRequest(this.context, sql, ((ExtendedQueryCommand)this.cmd).params()) : this.sendRequest(this.context, sql, ((ExtendedQueryCommand)this.cmd).paramsList()));
        }
        if (this.metrics != null) {
            sql = this.cmd.sql();
            this.metric = this.metrics.requestBegin(sql, (Object)sql);
            this.metrics.requestEnd(this.metric);
        }
    }

    public void after(Object res, Throwable err) {
        if (this.tracer != null) {
            QueryResultBuilder qbr = (QueryResultBuilder)this.cmd.resultHandler();
            this.receiveResponse(this.context, this.payload, err == null ? qbr.first : null, err);
        }
        if (this.metrics != null) {
            if (err == null) {
                this.metrics.responseBegin(this.metric, null);
                this.metrics.responseEnd(this.metric);
            } else {
                this.metrics.requestReset(this.metric);
            }
        }
    }

    static enum RequestTags {
        PEER_ADDRESS("network.peer.address", q -> q.tracer.address),
        SPAN_KIND("span.kind", q -> "client"),
        DB_USER("db.user", q -> q.tracer.user),
        DB_NAMESPACE("db.namespace", q -> q.tracer.database),
        DB_QUERY_TEXT("db.query.text", QueryRequest::sql),
        DB_SYSTEM("db.system", q -> q.tracer.system);

        final String name;
        final Function<QueryRequest, String> fn;

        private RequestTags(String name, Function<QueryRequest, String> fn) {
            this.name = name;
            this.fn = fn;
        }
    }
}

