/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.Utils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.NoSuchElementException;
import java.util.UUID;

@VertxGen
public interface Row
extends Tuple {
    public String getColumnName(int var1);

    public int getColumnIndex(String var1);

    default public Object getValue(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getValue(pos);
    }

    default public Boolean getBoolean(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getBoolean(pos);
    }

    default public Byte getByte(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getByte(pos);
    }

    default public Short getShort(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getShort(pos);
    }

    default public Integer getInteger(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getInteger(pos);
    }

    default public Long getLong(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getLong(pos);
    }

    default public Float getFloat(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getFloat(pos);
    }

    default public Double getDouble(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getDouble(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Numeric getNumeric(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getNumeric(pos);
    }

    default public String getString(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getString(pos);
    }

    default public Object getJson(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getJson(pos);
    }

    default public JsonObject getJsonObject(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getJsonObject(pos);
    }

    default public JsonArray getJsonArray(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getJsonArray(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Temporal getTemporal(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getTemporal(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDate getLocalDate(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getLocalDate(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalTime getLocalTime(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getLocalTime(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDateTime getLocalDateTime(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getLocalDateTime(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetTime getOffsetTime(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getOffsetTime(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetDateTime getOffsetDateTime(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getOffsetDateTime(pos);
    }

    default public Buffer getBuffer(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getBuffer(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public UUID getUUID(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getUUID(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public BigDecimal getBigDecimal(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getBigDecimal(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Boolean[] getArrayOfBooleans(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfBooleans(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Byte[] getArrayOfBytes(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfBytes(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Short[] getArrayOfShorts(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfShorts(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Integer[] getArrayOfIntegers(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfIntegers(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Long[] getArrayOfLongs(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfLongs(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Float[] getArrayOfFloats(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfFloats(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Double[] getArrayOfDoubles(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfDoubles(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Numeric[] getArrayOfNumerics(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfNumerics(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public String[] getArrayOfStrings(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfStrings(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public JsonObject[] getArrayOfJsonObjects(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfJsonObjects(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public JsonArray[] getArrayOfJsonArrays(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfJsonArrays(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Temporal[] getArrayOfTemporals(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfTemporals(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDate[] getArrayOfLocalDates(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfLocalDates(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalTime[] getArrayOfLocalTimes(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfLocalTimes(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDateTime[] getArrayOfLocalDateTimes(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfLocalDateTimes(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetTime[] getArrayOfOffsetTimes(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfOffsetTimes(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetDateTime[] getArrayOfOffsetDateTimes(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfOffsetDateTimes(pos);
    }

    @GenIgnore
    default public Buffer[] getArrayOfBuffers(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfBuffers(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public UUID[] getArrayOfUUIDs(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfUUIDs(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public BigDecimal[] getArrayOfBigDecimals(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfBigDecimals(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public Object[] getArrayOfJsons(String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.getArrayOfJsons(pos);
    }

    default public <T> T get(Class<T> type, String column) {
        int pos = this.getColumnIndex(column);
        if (pos == -1) {
            throw new NoSuchElementException("Column " + column + " does not exist");
        }
        return this.get(type, pos);
    }

    default public JsonObject toJson() {
        JsonObject json = new JsonObject();
        int size = this.size();
        for (int pos = 0; pos < size; ++pos) {
            String name = this.getColumnName(pos);
            Object value = this.getValue(pos);
            json.put(name, Utils.toJson(value));
        }
        return json;
    }

    default public void release() {
    }
}

