/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.internal.command;

import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.internal.PreparedStatement;
import io.vertx.sqlclient.internal.QueryResultHandler;
import io.vertx.sqlclient.internal.TupleInternal;
import io.vertx.sqlclient.internal.command.QueryCommandBase;
import java.util.List;
import java.util.stream.Collector;

public class ExtendedQueryCommand<R>
extends QueryCommandBase<R> {
    protected final String sql;
    protected final PrepareOptions options;
    public PreparedStatement ps;
    protected final boolean batch;
    private Object tuples;
    protected final int fetch;
    protected final String cursorId;
    protected final boolean suspended;
    private boolean prepared;

    public static <R> ExtendedQueryCommand<R> createQuery(String sql, PrepareOptions options, PreparedStatement ps, Tuple tuple, boolean autoCommit, Collector<Row, ?, R> collector, QueryResultHandler<R> resultHandler) {
        return new ExtendedQueryCommand<R>(sql, options, ps, false, tuple, 0, null, false, autoCommit, collector, resultHandler);
    }

    public static <R> ExtendedQueryCommand<R> createQuery(String sql, PrepareOptions options, PreparedStatement ps, Tuple tuple, int fetch, String cursorId, boolean suspended, boolean autoCommit, Collector<Row, ?, R> collector, QueryResultHandler<R> resultHandler) {
        return new ExtendedQueryCommand<R>(sql, options, ps, false, tuple, fetch, cursorId, suspended, autoCommit, collector, resultHandler);
    }

    public static <R> ExtendedQueryCommand<R> createBatch(String sql, PrepareOptions options, PreparedStatement ps, List<Tuple> tuples, boolean autoCommit, Collector<Row, ?, R> collector, QueryResultHandler<R> resultHandler) {
        return new ExtendedQueryCommand<R>(sql, options, ps, true, tuples, 0, null, false, autoCommit, collector, resultHandler);
    }

    private ExtendedQueryCommand(String sql, PrepareOptions options, PreparedStatement ps, boolean batch, Object tuples, int fetch, String cursorId, boolean suspended, boolean autoCommit, Collector<Row, ?, R> collector, QueryResultHandler<R> resultHandler) {
        super(autoCommit, collector, resultHandler);
        this.sql = sql;
        this.options = options;
        this.ps = ps;
        this.batch = batch;
        this.tuples = tuples;
        this.fetch = fetch;
        this.cursorId = cursorId;
        this.suspended = suspended;
        this.prepared = ps != null;
    }

    public PrepareOptions options() {
        return this.options;
    }

    public String prepare() {
        if (this.ps != null && !this.prepared) {
            this.prepared = true;
            try {
                if (this.batch) {
                    this.tuples = this.ps.prepare((List)this.tuples);
                    return null;
                }
                this.tuples = this.ps.prepare((TupleInternal)this.tuples);
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return null;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public List<TupleInternal> paramsList() {
        return this.batch ? (List)this.tuples : null;
    }

    public List<Class<?>> parameterTypes() {
        Tuple tuple;
        if (this.batch) {
            List list = (List)this.tuples;
            if (list.isEmpty()) {
                return null;
            }
            tuple = (Tuple)list.get(0);
        } else {
            tuple = (TupleInternal)this.tuples;
        }
        return tuple.types();
    }

    public TupleInternal params() {
        return this.batch ? null : (TupleInternal)this.tuples;
    }

    public PreparedStatement preparedStatement() {
        return this.ps;
    }

    public int fetch() {
        return this.fetch;
    }

    public String cursorId() {
        return this.cursorId;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public String sql() {
        return this.sql;
    }
}

