/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.pool;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.sqlclient.impl.ConnectionPool;
import io.vertx.sqlclient.impl.pool.ConnectionQueue;
import io.vertx.sqlclient.impl.pool.SimpleConnection;
import io.vertx.sqlclient.impl.pool.SimpleHolder;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionPoolTest {
    @Test
    public void testSimple() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 1);
        SimpleHolder holder = new SimpleHolder();
        pool.acquire((Handler)holder);
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertFalse((boolean)holder.isComplete());
        SimpleConnection conn = new SimpleConnection();
        queue.connect(conn);
        Assert.assertTrue((boolean)holder.isConnected());
        Assert.assertNotNull((Object)conn.holder);
        Assert.assertNotSame((Object)conn, (Object)holder.connection());
        holder.init();
        holder.close();
    }

    @Test
    public void testRecycle() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 1);
        SimpleHolder holder1 = new SimpleHolder();
        pool.acquire((Handler)holder1);
        SimpleConnection conn = new SimpleConnection();
        queue.connect(conn);
        holder1.init();
        SimpleHolder holder2 = new SimpleHolder();
        pool.acquire((Handler)holder2);
        Assert.assertFalse((boolean)holder2.isComplete());
        Assert.assertEquals((long)0L, (long)queue.size());
        holder1.close();
        Assert.assertEquals((long)0L, (long)conn.closed);
        Assert.assertEquals((long)0L, (long)holder1.closed());
        Assert.assertTrue((boolean)holder2.isConnected());
        Assert.assertEquals((long)0L, (long)queue.size());
    }

    @Test
    public void testConnectionCreation() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 1);
        SimpleHolder holder1 = new SimpleHolder();
        pool.acquire((Handler)holder1);
        SimpleHolder holder2 = new SimpleHolder();
        pool.acquire((Handler)holder2);
        Assert.assertEquals((long)1L, (long)queue.size());
        SimpleConnection conn = new SimpleConnection();
        queue.connect(conn);
        Assert.assertTrue((boolean)holder1.isConnected());
        Assert.assertEquals((long)0L, (long)queue.size());
    }

    @Test
    public void testConnClose() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 1);
        SimpleHolder holder1 = new SimpleHolder();
        pool.acquire((Handler)holder1);
        SimpleConnection conn = new SimpleConnection();
        queue.connect(conn);
        holder1.init();
        SimpleHolder holder2 = new SimpleHolder();
        pool.acquire((Handler)holder2);
        Assert.assertFalse((boolean)holder2.isComplete());
        Assert.assertEquals((long)0L, (long)queue.size());
        conn.close();
        Assert.assertEquals((long)1L, (long)holder1.closed());
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertFalse((boolean)holder2.isComplete());
    }

    @Test
    public void testConnectionCloseInPool() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 1);
        SimpleHolder holder = new SimpleHolder();
        pool.acquire((Handler)holder);
        SimpleConnection conn = new SimpleConnection();
        queue.connect(conn);
        holder.init();
        holder.close();
        conn.close();
        Assert.assertEquals((long)0L, (long)pool.available());
    }

    @Test
    public void testDoubleConnectionClose() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 1);
        SimpleHolder holder = new SimpleHolder();
        pool.acquire((Handler)holder);
        SimpleConnection conn = new SimpleConnection();
        queue.connect(conn);
        holder.init();
        conn.close();
        try {
            conn.close();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleConnectionRelease() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 1);
        SimpleHolder holder = new SimpleHolder();
        pool.acquire((Handler)holder);
        SimpleConnection conn = new SimpleConnection();
        queue.connect(conn);
        holder.init();
        holder.close();
        try {
            holder.close();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleConnectionAcquire() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 1);
        SimpleHolder holder = new SimpleHolder();
        pool.acquire((Handler)holder);
        SimpleConnection conn = new SimpleConnection();
        queue.connect(conn);
        holder.init();
        try {
            holder.init();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testReleaseConnectionWhenWaiterQueueIsEmpty() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 2);
        SimpleHolder holder1 = new SimpleHolder();
        pool.acquire((Handler)holder1);
        SimpleConnection conn1 = new SimpleConnection();
        queue.connect(conn1);
        holder1.init();
        SimpleHolder holder2 = new SimpleHolder();
        pool.acquire((Handler)holder2);
        holder1.close();
        Assert.assertEquals((long)1L, (long)pool.available());
        SimpleConnection conn2 = new SimpleConnection();
        queue.connect(conn2);
        holder2.init();
    }

    @Test
    public void testReleaseClosedConnectionShouldNotAddBackTheConnectionToThePool() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 1);
        SimpleHolder holder1 = new SimpleHolder();
        pool.acquire((Handler)holder1);
        SimpleConnection conn1 = new SimpleConnection();
        queue.connect(conn1);
        holder1.init();
        conn1.close();
        holder1.close();
        Assert.assertEquals((long)pool.available(), (long)0L);
    }

    @Test
    public void testMaxQueueSize1() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 1, 0);
        SimpleHolder holder1 = new SimpleHolder();
        pool.acquire((Handler)holder1);
        SimpleConnection conn = new SimpleConnection();
        queue.connect(conn);
        holder1.init();
        SimpleHolder holder2 = new SimpleHolder();
        pool.acquire((Handler)holder2);
        Assert.assertTrue((boolean)holder2.isFailed());
    }

    @Test
    public void testMaxQueueSize2() {
        ConnectionPool[] poolRef;
        SimpleHolder holder2 = new SimpleHolder();
        SimpleConnection conn = new SimpleConnection();
        ConnectionPool pool = new ConnectionPool(ar -> {
            poolRef[0].acquire((Handler)holder2);
            Assert.assertFalse((boolean)holder2.isComplete());
            ar.handle((Object)Future.succeededFuture((Object)conn));
            Assert.assertFalse((boolean)holder2.isComplete());
        }, 1, 0);
        poolRef = new ConnectionPool[]{pool};
        SimpleHolder holder1 = new SimpleHolder();
        pool.acquire((Handler)holder1);
        Assert.assertTrue((boolean)holder1.isComplete());
        Assert.assertTrue((boolean)holder2.isFailed());
    }

    @Test
    public void testConnectionFailure() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 1, 0);
        SimpleHolder holder1 = new SimpleHolder();
        pool.acquire((Handler)holder1);
        Exception cause = new Exception();
        queue.fail(cause);
        Assert.assertTrue((boolean)holder1.isFailed());
        Assert.assertSame((Object)cause, (Object)holder1.failure());
        Assert.assertEquals((long)0L, (long)pool.available());
        Assert.assertEquals((long)0L, (long)pool.size());
        SimpleHolder holder2 = new SimpleHolder();
        pool.acquire((Handler)holder2);
        SimpleConnection conn = new SimpleConnection();
        queue.connect(conn);
        Assert.assertTrue((boolean)holder2.isConnected());
        Assert.assertEquals((long)0L, (long)pool.available());
        Assert.assertEquals((long)1L, (long)pool.size());
    }

    @Test
    public void testAcquireOnlyConnectOnce() {
        ConnectionQueue queue = new ConnectionQueue();
        ConnectionPool pool = new ConnectionPool((Consumer)queue, 10, 0);
        SimpleHolder holder1 = new SimpleHolder();
        pool.acquire((Handler)holder1);
        Assert.assertEquals((long)1L, (long)queue.size());
    }
}

