/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.sockjs.generator;

import io.vertx.codegen.format.CamelCase;
import io.vertx.codegen.format.SnakeCase;
import io.vertx.codegen.processor.Helper;
import io.vertx.codegen.processor.MethodInfo;
import io.vertx.codegen.processor.MethodKind;
import io.vertx.codegen.processor.ParamInfo;
import io.vertx.codegen.processor.doc.Token;
import io.vertx.codegen.processor.type.ApiTypeInfo;
import io.vertx.codegen.processor.type.ClassKind;
import io.vertx.codegen.processor.type.ClassTypeInfo;
import io.vertx.codegen.processor.type.ParameterizedTypeInfo;
import io.vertx.codegen.processor.type.TypeInfo;
import io.vertx.codegen.processor.type.TypeVariableInfo;
import io.vertx.codegen.processor.writer.CodeWriter;
import io.vertx.serviceproxy.generator.model.ProxyMethodInfo;
import io.vertx.serviceproxy.generator.model.ProxyModel;
import io.vertx.serviceproxy.sockjs.generator.AbstractSockjsServiceProxyGenerator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SockjsServiceProxyJSGenerator
extends AbstractSockjsServiceProxyGenerator {
    SockjsServiceProxyJSGenerator() {
        this.name = "sockjs_service_proxies";
        this.kinds = Collections.singleton("proxy");
    }

    public String filename(ProxyModel model) {
        ClassTypeInfo type = model.getType();
        return type.getModuleName() + "-js/" + Helper.convertCamelCaseToUnderscores((String)type.getRaw().getSimpleName()) + "-proxy.js";
    }

    private String getModuleName(ClassTypeInfo type) {
        return type.getModuleName() + "-js/" + CamelCase.INSTANCE.to(SnakeCase.INSTANCE, type.getSimpleName());
    }

    private void genMethod(ProxyModel model, String methodName, boolean genStatic, Predicate<MethodInfo> methodFilter, CodeWriter writer) {
        ClassTypeInfo type = model.getType();
        String simpleName = type.getSimpleName();
        Map methodsByName = model.getMethodMap();
        ArrayList<MethodInfo> methodList = (ArrayList<MethodInfo>)methodsByName.get(methodName);
        if (methodFilter != null) {
            ArrayList<MethodInfo> methodTmpl = methodList;
            methodList = new ArrayList<MethodInfo>();
            for (MethodInfo method : methodTmpl) {
                if (!methodFilter.test(method)) continue;
                methodList.add(method);
            }
        }
        if (methodList.size() > 0) {
            boolean overloaded = methodList.size() > 1;
            MethodInfo method = (MethodInfo)methodList.get(methodList.size() - 1);
            if (genStatic == method.isStaticMethod()) {
                writer.println("/**");
                if (method.getDoc() != null) {
                    Token.toHtml((List)method.getDoc().getTokens(), (String)"", this::renderLinkToHtml, (String)"\n", (PrintWriter)writer);
                }
                writer.println();
                writer.print(" ");
                if (genStatic) {
                    writer.format("@memberof module:%s", new Object[]{this.getModuleName(type)}).println();
                } else {
                    writer.println("@public");
                }
                boolean first = true;
                for (ParamInfo param : method.getParams()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.println();
                    }
                    writer.format(" @param %s {%s} ", new Object[]{param.getName(), this.getJSDocType(param.getType())});
                    if (param.getDescription() == null) continue;
                    Token.toHtml((List)param.getDescription().getTokens(), (String)"", this::renderLinkToHtml, (String)"", (PrintWriter)writer);
                    writer.print(" ");
                }
                writer.println();
                if (method.getReturnType().getKind() != ClassKind.VOID) {
                    writer.format(" @return {%s}", new Object[]{this.getJSDocType(method.getReturnType())});
                    if (method.getReturnDescription() != null) {
                        writer.print(" ");
                        Token.toHtml((List)method.getReturnDescription().getTokens(), (String)"", this::renderLinkToHtml, (String)"", (PrintWriter)writer);
                    }
                    writer.println();
                }
                writer.println(" */");
                writer.format("%s.%s = ", new Object[]{genStatic ? simpleName : "this", methodName});
                if (overloaded) {
                    writer.println(" function() {");
                } else {
                    writer.format(" function(%s) {\n", new Object[]{method.getParams().stream().map(ParamInfo::getName).collect(Collectors.joining(", "))});
                }
                int mcnt = 0;
                writer.indent();
                writer.println("var __args = arguments;");
                for (MethodInfo m : methodList) {
                    writer.print(mcnt++ == 0 ? "if" : "else if");
                    int paramSize = m.getParams().size();
                    if (m.getKind() == MethodKind.FUTURE) {
                        writer.format(" (__args.length === %s", new Object[]{paramSize + 1});
                    } else {
                        writer.format(" (__args.length === %s", new Object[]{paramSize});
                    }
                    int cnt = 0;
                    if (paramSize > 0) {
                        writer.print(" && ");
                    }
                    first = true;
                    for (ParamInfo param : m.getParams()) {
                        if (first) {
                            first = false;
                        } else {
                            writer.print(" && ");
                        }
                        switch (param.getType().getKind()) {
                            case PRIMITIVE: 
                            case BOXED_PRIMITIVE: {
                                if (param.isNullable()) {
                                    writer.print("(");
                                }
                                writer.format("typeof __args[%s] ===", new Object[]{cnt});
                                String paramSimpleName = param.getType().getSimpleName();
                                if ("boolean".equalsIgnoreCase(paramSimpleName)) {
                                    writer.print("'boolean'");
                                } else if ("char".equals(paramSimpleName) || "Character".equals(paramSimpleName)) {
                                    writer.print("'string'");
                                } else {
                                    writer.print("'number'");
                                }
                                if (!param.isNullable()) break;
                                writer.format(" || __args[%s] == null)", new Object[]{cnt});
                                break;
                            }
                            case STRING: 
                            case ENUM: {
                                if (param.isNullable()) {
                                    writer.print("(");
                                }
                                writer.format("typeof __args[%s] === 'string'", new Object[]{cnt});
                                if (!param.isNullable()) break;
                                writer.format(" || __args[%s] == null)", new Object[]{cnt});
                                break;
                            }
                            case CLASS_TYPE: {
                                writer.format("typeof __args[%s] === 'function'", new Object[]{cnt});
                                break;
                            }
                            case API: {
                                writer.format("typeof __args[%s] === 'object' && ", new Object[]{cnt});
                                if (param.isNullable()) {
                                    writer.format("(__args[%s] == null || ", new Object[]{cnt});
                                }
                                writer.format("__args[%s]._jdel", new Object[]{cnt});
                                if (!param.isNullable()) break;
                                writer.print(")");
                                break;
                            }
                            case JSON_ARRAY: 
                            case LIST: 
                            case SET: {
                                writer.format("typeof __args[%s] === 'object' && ", new Object[]{cnt});
                                if (param.isNullable()) {
                                    writer.print("(");
                                }
                                writer.format("__args[%s] instanceof Array", new Object[]{cnt});
                                if (!param.isNullable()) break;
                                writer.format(" || __args[%s] == null)", new Object[]{cnt});
                                break;
                            }
                            case HANDLER: {
                                if (param.isNullable()) {
                                    writer.print("(");
                                }
                                writer.format("typeof __args[%s] === 'function'", new Object[]{cnt});
                                if (!param.isNullable()) break;
                                writer.format(" || __args[%s] == null)", new Object[]{cnt});
                                break;
                            }
                            case OBJECT: {
                                if (param.getType().isVariable() && ((TypeVariableInfo)param.getType()).isClassParam()) {
                                    writer.format("j_%s.accept(__args[%s])", new Object[]{param.getType().getName(), cnt});
                                    break;
                                }
                                writer.format("typeof __args[%s] !== 'function'", new Object[]{cnt});
                                break;
                            }
                            case FUNCTION: {
                                writer.format("typeof __args[%s] === 'function'", new Object[]{cnt});
                                break;
                            }
                            case THROWABLE: {
                                writer.format("typeof __args[%s] === 'object'", new Object[]{cnt});
                                break;
                            }
                            default: {
                                if (!param.isNullable()) {
                                    writer.print("(");
                                }
                                writer.format("typeof __args[%s] === 'object'", new Object[]{cnt});
                                if (param.isNullable()) break;
                                writer.format(" && __args[%s] != null)", new Object[]{cnt});
                            }
                        }
                        ++cnt;
                    }
                    writer.println(") {");
                    writer.indent();
                    this.genMethodAdapter(model, m, writer);
                    writer.unindent();
                    writer.print("}");
                }
                writer.unindent();
                writer.println(" else throw new TypeError('function invoked with invalid arguments');");
                writer.println("};");
                writer.println();
            }
        }
    }

    public String render(ProxyModel model, int index, int size, Map<String, Object> session) {
        String refedType;
        StringWriter sw = new StringWriter();
        CodeWriter writer = new CodeWriter((Writer)sw);
        ClassTypeInfo type = model.getType();
        String simpleName = type.getSimpleName();
        this.genLicenses((PrintWriter)writer);
        writer.println();
        writer.format("/// <reference path=\"./%s-proxy.d.ts\" />", new Object[]{Helper.convertCamelCaseToUnderscores((String)type.getRaw().getSimpleName())}).println();
        writer.println();
        writer.format("/** @module %s */", new Object[]{this.getModuleName(type)}).println();
        ArrayList<Object> imports = new ArrayList<Object>();
        writer.println("!function (factory) {");
        writer.indent().println("if (typeof require === 'function' && typeof module !== 'undefined') {");
        writer.indent();
        imports.clear();
        for (ApiTypeInfo referencedType : model.getReferencedTypes()) {
            if (!referencedType.isProxyGen()) continue;
            refedType = referencedType.getSimpleName();
            imports.add(refedType);
            writer.format("var %s = require('./%s-proxy');", new Object[]{refedType, this.getModuleName((ClassTypeInfo)referencedType)}).println();
        }
        writer.format("factory(%s);", new Object[]{String.join((CharSequence)", ", imports)}).println();
        writer.unindent().println("} else if (typeof define === 'function' && define.amd) {");
        writer.indent().println("// AMD loader");
        imports.clear();
        for (ApiTypeInfo referencedType : model.getReferencedTypes()) {
            if (!referencedType.isProxyGen()) continue;
            imports.add("'" + this.getModuleName((ClassTypeInfo)referencedType) + "-proxy'");
        }
        writer.format("define('%s-proxy', [%s], factory);", new Object[]{this.getModuleName(type), String.join((CharSequence)", ", imports)});
        writer.println();
        writer.unindent().println("} else {");
        writer.indent().println("// plain old include");
        imports.clear();
        for (ApiTypeInfo referencedType : model.getReferencedTypes()) {
            if (!referencedType.isProxyGen()) continue;
            refedType = referencedType.getSimpleName();
            imports.add("this." + refedType);
        }
        writer.format("%s = factory(%s);", new Object[]{simpleName, String.join((CharSequence)", ", imports)}).println();
        writer.unindent().println("}");
        imports.clear();
        for (ApiTypeInfo referencedType : model.getReferencedTypes()) {
            if (!referencedType.isProxyGen()) continue;
            refedType = referencedType.getSimpleName();
            imports.add(refedType);
        }
        writer.unindent().format("}(function (%s) {", new Object[]{String.join((CharSequence)", ", imports)}).println();
        writer.indent();
        writer.println();
        this.genDoc(model, writer);
        writer.format("var %s = function(eb, address) {", new Object[]{simpleName}).println();
        writer.indent().println("var j_eb = eb;");
        writer.println("var j_address = address;");
        writer.println("var closed = false;");
        writer.println("var that = this;");
        writer.println("var convCharCollection = function(coll) {");
        writer.indent().println("var ret = [];");
        writer.println("for (var i = 0;i < coll.length;i++) {");
        writer.indent().println("ret.push(String.fromCharCode(coll[i]));");
        writer.unindent().println("}");
        writer.println("return ret;");
        writer.unindent().println("};");
        for (TypeInfo superType : model.getSuperTypes()) {
            writer.format("%s.call(this, j_val);", new Object[]{superType.getRaw().getSimpleName()}).println();
        }
        writer.println();
        for (String methodName : model.getMethodMap().keySet()) {
            this.genMethod(model, methodName, false, this::methodFilter, writer);
        }
        writer.unindent().println("};");
        writer.println();
        for (String methodName : model.getMethodMap().keySet()) {
            this.genMethod(model, methodName, true, this::methodFilter, writer);
        }
        writer.println("if (typeof exports !== 'undefined') {");
        writer.indent().println("if (typeof module !== 'undefined' && module.exports) {");
        writer.indent().format("exports = module.exports = %s;", new Object[]{simpleName}).println();
        writer.unindent().println("} else {");
        writer.indent().format("exports.%s = %s;", new Object[]{simpleName, simpleName}).println();
        writer.unindent().println("}");
        writer.unindent().println("} else {");
        writer.indent().format("return %s;", new Object[]{simpleName}).println();
        writer.unindent().println("}");
        writer.unindent().print("});");
        return sw.toString();
    }

    private void genMethodAdapter(ProxyModel model, MethodInfo m, CodeWriter writer) {
        ProxyMethodInfo method = (ProxyMethodInfo)m;
        writer.println("if (closed) {");
        writer.indent().println("throw new Error('Proxy is closed');");
        writer.unindent().println("}");
        this.genMethodCall((MethodInfo)method, (PrintWriter)writer);
        writer.println(";");
        if (method.isProxyClose()) {
            writer.println("closed = true;");
        }
        if (method.isFluent()) {
            writer.println("return that;");
        } else {
            writer.println("return;");
        }
    }

    private void genMethodCall(MethodInfo method, PrintWriter writer) {
        List params = method.getParams();
        boolean hasResultHandler = method.getKind() == MethodKind.FUTURE;
        writer.print("j_eb.send(j_address, {");
        boolean first = true;
        for (int pcnt = 0; pcnt < params.size(); ++pcnt) {
            if (first) {
                first = false;
            } else {
                writer.print(", ");
            }
            ParamInfo param = (ParamInfo)params.get(pcnt);
            String paramTypeName = param.getType().getName();
            String paramName = param.getName();
            writer.format("\"%s\":", paramName);
            if ("java.lang.Character".equals(paramTypeName) || "char".equals(paramTypeName)) {
                writer.format("__args[%d].charCodeAt(0)", pcnt);
                continue;
            }
            writer.format("__args[%d]", pcnt);
        }
        writer.format("}, {\"action\":\"%s\"}", method.getName());
        if (hasResultHandler) {
            ParameterizedTypeInfo futureType = (ParameterizedTypeInfo)method.getReturnType();
            TypeInfo resultType = futureType.getArg(0);
            writer.format(", function(err, result) { __args[%d](err, result && ", params.size());
            ClassKind resultKind = resultType.getKind();
            if (resultType.getKind() == ClassKind.API) {
                writer.format("new %s(j_eb, result.headers.proxyaddr)", resultType.getSimpleName());
            } else if ((resultKind == ClassKind.LIST || resultKind == ClassKind.SET) && "java.lang.Character".equals(((ParameterizedTypeInfo)resultType).getArg(0).getName())) {
                writer.print("convCharCollection(result.body)");
            } else {
                writer.print("result.body");
            }
            writer.print("); }");
        }
        writer.print(")");
    }

    void genDoc(ProxyModel model, CodeWriter writer) {
        writer.println("/**");
        if (model.getIfaceComment() != null) {
            writer.println(Helper.removeTags((String)model.getIfaceComment()));
        }
        writer.println(" @class");
        writer.println("*/");
    }
}

