/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.dns;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.dns.MxRecord;
import io.vertx.core.dns.SrvRecord;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.MaybeHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.core.dns.DnsClient.class)
public class DnsClient
implements RxDelegate {
    public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg(obj -> new DnsClient((io.vertx.core.dns.DnsClient)obj), DnsClient::getDelegate);
    private final io.vertx.core.dns.DnsClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsClient that = (DnsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DnsClient(io.vertx.core.dns.DnsClient delegate) {
        this.delegate = delegate;
    }

    public DnsClient(Object delegate) {
        this.delegate = (io.vertx.core.dns.DnsClient)delegate;
    }

    public io.vertx.core.dns.DnsClient getDelegate() {
        return this.delegate;
    }

    public Maybe<String> lookup(String name) {
        Maybe ret = this.rxLookup(name);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxLookup(String name) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.lookup(name), __value -> __value);
    }

    public Maybe<String> lookup4(String name) {
        Maybe ret = this.rxLookup4(name);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxLookup4(String name) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.lookup4(name), __value -> __value);
    }

    public Maybe<String> lookup6(String name) {
        Maybe ret = this.rxLookup6(name);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxLookup6(String name) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.lookup6(name), __value -> __value);
    }

    public Single<List<String>> resolveA(String name) {
        Single ret = this.rxResolveA(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxResolveA(String name) {
        return AsyncResultSingle.toSingle(() -> this.delegate.resolveA(name), __value -> __value);
    }

    public Single<List<String>> resolveAAAA(String name) {
        Single ret = this.rxResolveAAAA(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxResolveAAAA(String name) {
        return AsyncResultSingle.toSingle(() -> this.delegate.resolveAAAA(name), __value -> __value);
    }

    public Single<List<String>> resolveCNAME(String name) {
        Single ret = this.rxResolveCNAME(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxResolveCNAME(String name) {
        return AsyncResultSingle.toSingle(() -> this.delegate.resolveCNAME(name), __value -> __value);
    }

    public Single<List<MxRecord>> resolveMX(String name) {
        Single ret = this.rxResolveMX(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<MxRecord>> rxResolveMX(String name) {
        return AsyncResultSingle.toSingle(() -> this.delegate.resolveMX(name), __value -> __value);
    }

    public Single<List<String>> resolveTXT(String name) {
        Single ret = this.rxResolveTXT(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxResolveTXT(String name) {
        return AsyncResultSingle.toSingle(() -> this.delegate.resolveTXT(name), __value -> __value);
    }

    public Maybe<String> resolvePTR(String name) {
        Maybe ret = this.rxResolvePTR(name);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxResolvePTR(String name) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.resolvePTR(name), __value -> __value);
    }

    public Single<List<String>> resolveNS(String name) {
        Single ret = this.rxResolveNS(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxResolveNS(String name) {
        return AsyncResultSingle.toSingle(() -> this.delegate.resolveNS(name), __value -> __value);
    }

    public Single<List<SrvRecord>> resolveSRV(String name) {
        Single ret = this.rxResolveSRV(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<SrvRecord>> rxResolveSRV(String name) {
        return AsyncResultSingle.toSingle(() -> this.delegate.resolveSRV(name), __value -> __value);
    }

    public Maybe<String> reverseLookup(String ipaddress) {
        Maybe ret = this.rxReverseLookup(ipaddress);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxReverseLookup(String ipaddress) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.reverseLookup(ipaddress), __value -> __value);
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
        return arg != null ? new DnsClient(arg) : null;
    }
}

