/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.http;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.net.HostAndPort;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.ReadStreamSubscriber;
import java.util.Set;

@RxGen(value=io.vertx.core.http.HttpServerResponse.class)
public class HttpServerResponse
implements WriteStream<Buffer> {
    public static final TypeArg<HttpServerResponse> __TYPE_ARG = new TypeArg(obj -> new HttpServerResponse((io.vertx.core.http.HttpServerResponse)obj), HttpServerResponse::getDelegate);
    private final io.vertx.core.http.HttpServerResponse delegate;
    private WriteStreamObserver<Buffer> observer;
    private WriteStreamSubscriber<Buffer> subscriber;
    private static final TypeArg<HttpServerResponse> TYPE_ARG_0 = new TypeArg(o1 -> HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServerResponse> TYPE_ARG_1 = new TypeArg(o1 -> HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServerResponse> TYPE_ARG_2 = new TypeArg(o1 -> HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServerResponse> TYPE_ARG_3 = new TypeArg(o1 -> HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServerResponse> TYPE_ARG_4 = new TypeArg(o1 -> HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)o1), o1 -> o1.getDelegate());
    private MultiMap cached_0;
    private MultiMap cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerResponse that = (HttpServerResponse)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServerResponse(io.vertx.core.http.HttpServerResponse delegate) {
        this.delegate = delegate;
    }

    public HttpServerResponse(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServerResponse)delegate;
    }

    public io.vertx.core.http.HttpServerResponse getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized WriteStreamObserver<Buffer> toObserver() {
        if (this.observer == null) {
            this.observer = RxHelper.toObserver((io.vertx.core.streams.WriteStream)this.getDelegate());
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate());
        }
        return this.subscriber;
    }

    @Override
    public Completable write(Buffer data) {
        Completable ret = this.rxWrite(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.write((Object)data));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpServerResponse drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public int getStatusCode() {
        int ret = this.delegate.getStatusCode();
        return ret;
    }

    public HttpServerResponse setStatusCode(int statusCode) {
        this.delegate.setStatusCode(statusCode);
        return this;
    }

    public String getStatusMessage() {
        String ret = this.delegate.getStatusMessage();
        return ret;
    }

    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.delegate.setStatusMessage(statusMessage);
        return this;
    }

    public HttpServerResponse setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.headers();
        return ret;
    }

    public HttpServerResponse putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.trailers();
        return ret;
    }

    public HttpServerResponse putTrailer(String name, String value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public HttpServerResponse closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public HttpServerResponse endHandler(Handler<Void> handler) {
        this.delegate.endHandler(handler);
        return this;
    }

    public Completable write(String chunk, String enc) {
        Completable ret = this.rxWrite(chunk, enc);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWrite(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.write(chunk, enc));
    }

    @Override
    public Completable write(String chunk) {
        Completable ret = this.rxWrite(chunk);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(String chunk) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.write(chunk));
    }

    public Completable writeContinue() {
        Completable ret = this.rxWriteContinue();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWriteContinue() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writeContinue());
    }

    public Completable writeEarlyHints(MultiMap headers) {
        Completable ret = this.rxWriteEarlyHints(headers);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWriteEarlyHints(MultiMap headers) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writeEarlyHints(headers));
    }

    @Override
    public Completable end(String chunk) {
        Completable ret = this.rxEnd(chunk);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(String chunk) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.end(chunk));
    }

    public Completable end(String chunk, String enc) {
        Completable ret = this.rxEnd(chunk, enc);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxEnd(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.end(chunk, enc));
    }

    @Override
    public Completable end(Buffer chunk) {
        Completable ret = this.rxEnd(chunk);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(Buffer chunk) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.end(chunk));
    }

    @Override
    public Completable end() {
        Completable ret = this.rxEnd();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.end());
    }

    public Completable send() {
        Completable ret = this.rxSend();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.send());
    }

    public Completable send(String body) {
        Completable ret = this.rxSend(body);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(String body) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.send(body));
    }

    public Completable send(Buffer body) {
        Completable ret = this.rxSend(body);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(Buffer body) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.send(body));
    }

    public Completable send(Flowable<Buffer> body) {
        Completable ret = this.rxSend(body);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(Flowable<Buffer> body) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.send(ReadStreamSubscriber.asReadStream((Flowable)body, obj -> obj).resume()));
    }

    public Completable sendFile(String filename) {
        Completable ret = this.rxSendFile(filename);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.sendFile(filename));
    }

    public Completable sendFile(String filename, long offset) {
        Completable ret = this.rxSendFile(filename, offset);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename, long offset) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.sendFile(filename, offset));
    }

    public Completable sendFile(String filename, long offset, long length) {
        Completable ret = this.rxSendFile(filename, offset, length);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename, long offset, long length) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.sendFile(filename, offset, length));
    }

    public boolean ended() {
        boolean ret = this.delegate.ended();
        return ret;
    }

    public boolean closed() {
        boolean ret = this.delegate.closed();
        return ret;
    }

    public boolean headWritten() {
        boolean ret = this.delegate.headWritten();
        return ret;
    }

    public HttpServerResponse headersEndHandler(Handler<Void> handler) {
        this.delegate.headersEndHandler(handler);
        return this;
    }

    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        this.delegate.bodyEndHandler(handler);
        return this;
    }

    public long bytesWritten() {
        long ret = this.delegate.bytesWritten();
        return ret;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public Single<HttpServerResponse> push(HttpMethod method, String host, String path) {
        Single ret = this.rxPush(method, host, path);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path) {
        return AsyncResultSingle.toSingle(() -> this.delegate.push(method, host, path), __value -> HttpServerResponse.newInstance(__value));
    }

    public Single<HttpServerResponse> push(HttpMethod method, String path, MultiMap headers) {
        Single ret = this.rxPush(method, path, headers);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path, MultiMap headers) {
        return AsyncResultSingle.toSingle(() -> this.delegate.push(method, path, headers), __value -> HttpServerResponse.newInstance(__value));
    }

    public Single<HttpServerResponse> push(HttpMethod method, String path) {
        Single ret = this.rxPush(method, path);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path) {
        return AsyncResultSingle.toSingle(() -> this.delegate.push(method, path), __value -> HttpServerResponse.newInstance(__value));
    }

    public Single<HttpServerResponse> push(HttpMethod method, HostAndPort authority, String path, MultiMap headers) {
        Single ret = this.rxPush(method, authority, path, headers);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, HostAndPort authority, String path, MultiMap headers) {
        return AsyncResultSingle.toSingle(() -> this.delegate.push(method, authority, path, headers), __value -> HttpServerResponse.newInstance(__value));
    }

    @Deprecated
    public Single<HttpServerResponse> push(HttpMethod method, String host, String path, MultiMap headers) {
        Single ret = this.rxPush(method, host, path, headers);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    @Deprecated
    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path, MultiMap headers) {
        return AsyncResultSingle.toSingle(() -> this.delegate.push(method, host, path, headers), __value -> HttpServerResponse.newInstance(__value));
    }

    public Completable reset() {
        Completable ret = this.rxReset();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxReset() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.reset());
    }

    public Completable reset(long code) {
        Completable ret = this.rxReset(code);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxReset(long code) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.reset(code));
    }

    public Completable writeCustomFrame(int type, int flags, Buffer payload) {
        Completable ret = this.rxWriteCustomFrame(type, flags, payload);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWriteCustomFrame(int type, int flags, Buffer payload) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writeCustomFrame(type, flags, payload));
    }

    public Completable writeCustomFrame(HttpFrame frame) {
        Completable ret = this.rxWriteCustomFrame(frame);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWriteCustomFrame(HttpFrame frame) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writeCustomFrame(frame));
    }

    public HttpServerResponse setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public HttpServerResponse addCookie(Cookie cookie) {
        this.delegate.addCookie(cookie);
        return this;
    }

    public Cookie removeCookie(String name) {
        Cookie ret = this.delegate.removeCookie(name);
        return ret;
    }

    public Cookie removeCookie(String name, boolean invalidate) {
        Cookie ret = this.delegate.removeCookie(name, invalidate);
        return ret;
    }

    public Set<Cookie> removeCookies(String name) {
        Set ret = this.delegate.removeCookies(name);
        return ret;
    }

    public Set<Cookie> removeCookies(String name, boolean invalidate) {
        Set ret = this.delegate.removeCookies(name, invalidate);
        return ret;
    }

    public Cookie removeCookie(String name, String domain, String path) {
        Cookie ret = this.delegate.removeCookie(name, domain, path);
        return ret;
    }

    public Cookie removeCookie(String name, String domain, String path, boolean invalidate) {
        Cookie ret = this.delegate.removeCookie(name, domain, path, invalidate);
        return ret;
    }

    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpServerResponse putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public HttpServerResponse putTrailer(String name, Iterable<String> values) {
        this.delegate.putTrailer(name, values);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public static HttpServerResponse newInstance(io.vertx.core.http.HttpServerResponse arg) {
        return arg != null ? new HttpServerResponse(arg) : null;
    }
}

