/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.file;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import io.vertx.rxjava3.core.file.AsyncFileLock;
import io.vertx.rxjava3.core.streams.Pipe;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.function.Supplier;

@RxGen(value=io.vertx.core.file.AsyncFile.class)
public class AsyncFile
implements ReadStream<Buffer>,
WriteStream<Buffer> {
    public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg(obj -> new AsyncFile((io.vertx.core.file.AsyncFile)obj), AsyncFile::getDelegate);
    private final io.vertx.core.file.AsyncFile delegate;
    private Observable<Buffer> observable;
    private Flowable<Buffer> flowable;
    private WriteStreamObserver<Buffer> observer;
    private WriteStreamSubscriber<Buffer> subscriber;
    private static final TypeArg<AsyncFileLock> TYPE_ARG_0 = new TypeArg(o1 -> AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)o1), o1 -> o1.getDelegate());
    private static final TypeArg<AsyncFileLock> TYPE_ARG_1 = new TypeArg(o1 -> AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncFile that = (AsyncFile)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
        this.delegate = delegate;
    }

    public AsyncFile(Object delegate) {
        this.delegate = (io.vertx.core.file.AsyncFile)delegate;
    }

    public io.vertx.core.file.AsyncFile getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            this.observable = ObservableHelper.toObservable((io.vertx.core.streams.ReadStream)this.getDelegate());
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<Buffer> toFlowable() {
        if (this.flowable == null) {
            this.flowable = FlowableHelper.toFlowable((io.vertx.core.streams.ReadStream)this.getDelegate());
        }
        return this.flowable;
    }

    @Override
    public synchronized WriteStreamObserver<Buffer> toObserver() {
        if (this.observer == null) {
            this.observer = RxHelper.toObserver((io.vertx.core.streams.WriteStream)this.getDelegate());
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate());
        }
        return this.subscriber;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TypeArg.unknown());
        return ret;
    }

    @Override
    public Completable pipeTo(WriteStream<Buffer> dst) {
        Completable ret = this.rxPipeTo(dst);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<Buffer> dst) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.pipeTo(dst.getDelegate()));
    }

    @Override
    public Completable write(Buffer data) {
        Completable ret = this.rxWrite(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.write((Object)data));
    }

    @Override
    public Completable end() {
        Completable ret = this.rxEnd();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.end());
    }

    @Override
    public Completable end(Buffer data) {
        Completable ret = this.rxEnd(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.end((Object)data));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    public AsyncFile handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        return this;
    }

    public AsyncFile pause() {
        this.delegate.pause();
        return this;
    }

    public AsyncFile resume() {
        this.delegate.resume();
        return this;
    }

    public AsyncFile endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public AsyncFile setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public AsyncFile drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public AsyncFile exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AsyncFile fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public Completable write(Buffer buffer, long position) {
        Completable ret = this.rxWrite(buffer, position);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWrite(Buffer buffer, long position) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.write(buffer, position));
    }

    public Single<Buffer> read(Buffer buffer, int offset, long position, int length) {
        Single ret = this.rxRead(buffer, offset, position, length);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Buffer> rxRead(Buffer buffer, int offset, long position, int length) {
        return AsyncResultSingle.toSingle(() -> this.delegate.read(buffer, offset, position, length), __value -> __value);
    }

    public Completable flush() {
        Completable ret = this.rxFlush();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxFlush() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.flush());
    }

    public AsyncFile setReadPos(long readPos) {
        this.delegate.setReadPos(readPos);
        return this;
    }

    public AsyncFile setReadLength(long readLength) {
        this.delegate.setReadLength(readLength);
        return this;
    }

    public long getReadLength() {
        long ret = this.delegate.getReadLength();
        return ret;
    }

    public AsyncFile setWritePos(long writePos) {
        this.delegate.setWritePos(writePos);
        return this;
    }

    public long getWritePos() {
        long ret = this.delegate.getWritePos();
        return ret;
    }

    public AsyncFile setReadBufferSize(int readBufferSize) {
        this.delegate.setReadBufferSize(readBufferSize);
        return this;
    }

    public long sizeBlocking() {
        long ret = this.delegate.sizeBlocking();
        return ret;
    }

    public Single<Long> size() {
        Single ret = this.rxSize();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxSize() {
        return AsyncResultSingle.toSingle(() -> this.delegate.size(), __value -> __value);
    }

    public AsyncFileLock tryLock() {
        AsyncFileLock ret = AsyncFileLock.newInstance(this.delegate.tryLock());
        return ret;
    }

    public AsyncFileLock tryLock(long position, long size, boolean shared) {
        AsyncFileLock ret = AsyncFileLock.newInstance(this.delegate.tryLock(position, size, shared));
        return ret;
    }

    public Single<AsyncFileLock> lock() {
        Single ret = this.rxLock();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AsyncFileLock> rxLock() {
        return AsyncResultSingle.toSingle(() -> this.delegate.lock(), __value -> AsyncFileLock.newInstance(__value));
    }

    public Single<AsyncFileLock> lock(long position, long size, boolean shared) {
        Single ret = this.rxLock(position, size, shared);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AsyncFileLock> rxLock(long position, long size, boolean shared) {
        return AsyncResultSingle.toSingle(() -> this.delegate.lock(position, size, shared), __value -> AsyncFileLock.newInstance(__value));
    }

    public <T> Single<T> withLock(Supplier<Single<T>> block) {
        Single ret = this.rxWithLock(block);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public <T> Single<T> rxWithLock(final Supplier<Single<T>> block) {
        return AsyncResultSingle.toSingle(() -> this.delegate.withLock(new Supplier<Future<T>>(){

            @Override
            public Future<T> get() {
                Single ret = (Single)block.get();
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        }), __value -> __value);
    }

    public <T> Single<T> withLock(long position, long size, boolean shared, Supplier<Single<T>> block) {
        Single ret = this.rxWithLock(position, size, shared, block);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public <T> Single<T> rxWithLock(long position, long size, boolean shared, final Supplier<Single<T>> block) {
        return AsyncResultSingle.toSingle(() -> this.delegate.withLock(position, size, shared, new Supplier<Future<T>>(){

            @Override
            public Future<T> get() {
                Single ret = (Single)block.get();
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        }), __value -> __value);
    }

    public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
        return arg != null ? new AsyncFile(arg) : null;
    }
}

