/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.kafka.admin;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Vertx;
import io.vertx.kafka.admin.ClusterDescription;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.DescribeClusterOptions;
import io.vertx.kafka.admin.DescribeConsumerGroupsOptions;
import io.vertx.kafka.admin.DescribeTopicsOptions;
import io.vertx.kafka.admin.NewPartitions;
import io.vertx.kafka.admin.NewTopic;
import io.vertx.kafka.admin.TopicDescription;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;

@RxGen(value=io.vertx.kafka.admin.KafkaAdminClient.class)
public class KafkaAdminClient {
    public static final TypeArg<KafkaAdminClient> __TYPE_ARG = new TypeArg(obj -> new KafkaAdminClient((io.vertx.kafka.admin.KafkaAdminClient)obj), KafkaAdminClient::getDelegate);
    private final io.vertx.kafka.admin.KafkaAdminClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaAdminClient that = (KafkaAdminClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public KafkaAdminClient(io.vertx.kafka.admin.KafkaAdminClient delegate) {
        this.delegate = delegate;
    }

    public KafkaAdminClient(Object delegate) {
        this.delegate = (io.vertx.kafka.admin.KafkaAdminClient)delegate;
    }

    public io.vertx.kafka.admin.KafkaAdminClient getDelegate() {
        return this.delegate;
    }

    public static KafkaAdminClient create(io.vertx.rxjava3.core.Vertx vertx, Map<String, String> config) {
        KafkaAdminClient ret = KafkaAdminClient.newInstance(io.vertx.kafka.admin.KafkaAdminClient.create((Vertx)vertx.getDelegate(), config));
        return ret;
    }

    public Single<Set<String>> listTopics() {
        Single ret = this.rxListTopics();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Set<String>> rxListTopics() {
        return AsyncResultSingle.toSingle(() -> this.delegate.listTopics(), __value -> __value);
    }

    public Single<Map<String, TopicDescription>> describeTopics(List<String> topicNames) {
        Single ret = this.rxDescribeTopics(topicNames);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Map<String, TopicDescription>> rxDescribeTopics(List<String> topicNames) {
        return AsyncResultSingle.toSingle(() -> this.delegate.describeTopics(topicNames), __value -> __value);
    }

    public Single<Map<String, TopicDescription>> describeTopics(List<String> topicNames, DescribeTopicsOptions options) {
        Single ret = this.rxDescribeTopics(topicNames, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Map<String, TopicDescription>> rxDescribeTopics(List<String> topicNames, DescribeTopicsOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.describeTopics(topicNames, options), __value -> __value);
    }

    public Completable createTopics(List<NewTopic> topics) {
        Completable ret = this.rxCreateTopics(topics);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCreateTopics(List<NewTopic> topics) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.createTopics(topics));
    }

    public Completable deleteTopics(List<String> topicNames) {
        Completable ret = this.rxDeleteTopics(topicNames);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDeleteTopics(List<String> topicNames) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.deleteTopics(topicNames));
    }

    public Completable createPartitions(Map<String, NewPartitions> partitions) {
        Completable ret = this.rxCreatePartitions(partitions);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCreatePartitions(Map<String, NewPartitions> partitions) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.createPartitions(partitions));
    }

    public Single<List<ConsumerGroupListing>> listConsumerGroups() {
        Single ret = this.rxListConsumerGroups();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<ConsumerGroupListing>> rxListConsumerGroups() {
        return AsyncResultSingle.toSingle(() -> this.delegate.listConsumerGroups(), __value -> __value);
    }

    public Single<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> groupIds) {
        Single ret = this.rxDescribeConsumerGroups(groupIds);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Map<String, ConsumerGroupDescription>> rxDescribeConsumerGroups(List<String> groupIds) {
        return AsyncResultSingle.toSingle(() -> this.delegate.describeConsumerGroups(groupIds), __value -> __value);
    }

    public Single<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> groupIds, DescribeConsumerGroupsOptions options) {
        Single ret = this.rxDescribeConsumerGroups(groupIds, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Map<String, ConsumerGroupDescription>> rxDescribeConsumerGroups(List<String> groupIds, DescribeConsumerGroupsOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.describeConsumerGroups(groupIds, options), __value -> __value);
    }

    public Single<ClusterDescription> describeCluster() {
        Single ret = this.rxDescribeCluster();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<ClusterDescription> rxDescribeCluster() {
        return AsyncResultSingle.toSingle(() -> this.delegate.describeCluster(), __value -> __value);
    }

    public Single<ClusterDescription> describeCluster(DescribeClusterOptions options) {
        Single ret = this.rxDescribeCluster(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<ClusterDescription> rxDescribeCluster(DescribeClusterOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.describeCluster(options), __value -> __value);
    }

    public Completable deleteConsumerGroups(List<String> groupIds) {
        Completable ret = this.rxDeleteConsumerGroups(groupIds);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDeleteConsumerGroups(List<String> groupIds) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.deleteConsumerGroups(groupIds));
    }

    public Completable deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions) {
        Completable ret = this.rxDeleteConsumerGroupOffsets(groupId, partitions);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDeleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.deleteConsumerGroupOffsets(groupId, partitions));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public Completable close(long timeout) {
        Completable ret = this.rxClose(timeout);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose(long timeout) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close(timeout));
    }

    public Single<List<AclBinding>> describeAcls(AclBindingFilter aclBindingFilter) {
        Single ret = this.rxDescribeAcls(aclBindingFilter);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<AclBinding>> rxDescribeAcls(AclBindingFilter aclBindingFilter) {
        return AsyncResultSingle.toSingle(() -> this.delegate.describeAcls(aclBindingFilter), __value -> __value);
    }

    public Single<List<AclBinding>> createAcls(List<AclBinding> aclBindings) {
        Single ret = this.rxCreateAcls(aclBindings);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<AclBinding>> rxCreateAcls(List<AclBinding> aclBindings) {
        return AsyncResultSingle.toSingle(() -> this.delegate.createAcls(aclBindings), __value -> __value);
    }

    public Single<List<AclBinding>> deleteAcls(List<AclBindingFilter> aclBindings) {
        Single ret = this.rxDeleteAcls(aclBindings);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<AclBinding>> rxDeleteAcls(List<AclBindingFilter> aclBindings) {
        return AsyncResultSingle.toSingle(() -> this.delegate.deleteAcls(aclBindings), __value -> __value);
    }

    public static KafkaAdminClient newInstance(io.vertx.kafka.admin.KafkaAdminClient arg) {
        return arg != null ? new KafkaAdminClient(arg) : null;
    }
}

